/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.engine.MultiIntervalShard;
import org.broadinstitute.hellbender.engine.ReadsDataSource;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsamplingIterator;
import org.broadinstitute.hellbender.utils.iterators.ReadFilteringIterator;
import org.broadinstitute.hellbender.utils.iterators.ReadTransformingIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class MultiIntervalLocalReadShard
implements MultiIntervalShard<GATKRead> {
    private final List<SimpleInterval> intervals;
    private final List<SimpleInterval> paddedIntervals;
    private final ReadsDataSource readsSource;
    private ReadTransformer preReadFilterTransformer;
    private ReadFilter readFilter;
    private ReadTransformer postReadFilterTransformer;
    private ReadsDownsampler downsampler;

    public MultiIntervalLocalReadShard(List<SimpleInterval> intervals, int intervalPadding, ReadsDataSource readsSource) {
        Utils.nonNull(intervals);
        Utils.nonNull(readsSource);
        Utils.validateArg(intervalPadding >= 0, "intervalPadding must be >= 0");
        this.intervals = Collections.unmodifiableList(IntervalUtils.getIntervalsWithFlanks(intervals, 0, readsSource.getSequenceDictionary()));
        this.paddedIntervals = Collections.unmodifiableList(IntervalUtils.getIntervalsWithFlanks(intervals, intervalPadding, readsSource.getSequenceDictionary()));
        this.readsSource = readsSource;
    }

    public MultiIntervalLocalReadShard(List<SimpleInterval> intervals, ReadsDataSource readsSource) {
        this(intervals, 0, readsSource);
    }

    @Override
    public List<SimpleInterval> getIntervals() {
        return this.intervals;
    }

    @Override
    public List<SimpleInterval> getPaddedIntervals() {
        return this.paddedIntervals;
    }

    public void setPreReadFilterTransformer(ReadTransformer transformer) {
        this.preReadFilterTransformer = transformer;
    }

    public void setReadFilter(ReadFilter filter) {
        this.readFilter = filter;
    }

    public void setDownsampler(ReadsDownsampler downsampler) {
        this.downsampler = downsampler;
    }

    public void setPostReadFilterTransformer(ReadTransformer transformer) {
        this.postReadFilterTransformer = transformer;
    }

    @Override
    public Iterator<GATKRead> iterator() {
        this.readsSource.setTraversalBounds(this.paddedIntervals);
        Iterable<GATKRead> readsIterator = this.readsSource.iterator();
        if (this.preReadFilterTransformer != null) {
            readsIterator = new ReadTransformingIterator((Iterator<GATKRead>)((Object)readsIterator), this.preReadFilterTransformer);
        }
        if (this.readFilter != null) {
            readsIterator = new ReadFilteringIterator((Iterator<GATKRead>)((Object)readsIterator), this.readFilter);
        }
        if (this.postReadFilterTransformer != null) {
            readsIterator = new ReadTransformingIterator((Iterator<GATKRead>)((Object)readsIterator), this.postReadFilterTransformer);
        }
        if (this.downsampler != null) {
            readsIterator = new ReadsDownsamplingIterator((Iterator<GATKRead>)((Object)readsIterator), this.downsampler);
        }
        return readsIterator;
    }
}

