/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.MergingIterator;
import htsjdk.tribble.Feature;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SequenceDictionaryUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;

public final class MultiVariantDataSource
implements GATKDataSource<VariantContext>,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(MultiVariantDataSource.class);
    private final List<FeatureDataSource<VariantContext>> featureDataSources = new ArrayList<FeatureDataSource<VariantContext>>();
    private final VCFHeader mergedHeader;
    private CloseableIterator<VariantContext> currentIterator;
    private SortedSet<String> mergedSamples;

    public MultiVariantDataSource(List<FeatureInput<VariantContext>> featureInputs, int queryLookaheadBases) {
        this(featureInputs, queryLookaheadBases, 0, 0, null, false);
    }

    public MultiVariantDataSource(List<FeatureInput<VariantContext>> featureInputs, int queryLookaheadBases, int cloudPrefetchBuffer, int cloudIndexPrefetchBuffer, Path reference, boolean skipDictionaryValidation) {
        Utils.validateArg(queryLookaheadBases >= 0, "Query lookahead bases must be >= 0");
        Utils.validateArg(featureInputs != null && featureInputs.size() > 0, "FeatureInputs list must be non-null and non-empty");
        featureInputs.forEach(featureInput -> this.featureDataSources.add(new FeatureDataSource(featureInput, queryLookaheadBases, (Class<? extends Feature>)((Class<Feature>)VariantContext.class), cloudPrefetchBuffer, cloudIndexPrefetchBuffer, reference)));
        if (!skipDictionaryValidation) {
            this.validateAllSequenceDictionaries();
        }
        this.mergedHeader = this.getMergedHeader();
        this.mergedSamples = this.getSortedSamples();
        if ((this.mergedHeader == null || this.mergedHeader.getSequenceDictionary() == null) && featureInputs.size() > 1) {
            throw new UserException("No sequence dictionary was found for any input. When using multiple inputs, at least one input must have a sequence dictionary, or an index from which a sequence dictionary can be derived.");
        }
    }

    public SAMSequenceDictionary getSequenceDictionary() {
        return this.mergedHeader == null ? null : this.mergedHeader.getSequenceDictionary();
    }

    public VCFHeader getHeader() {
        return this.mergedHeader;
    }

    public void setIntervalsForTraversal(List<SimpleInterval> intervals) {
        this.featureDataSources.forEach(ds -> ds.setIntervalsForTraversal(intervals));
    }

    @Override
    public Iterator<VariantContext> iterator() {
        return this.getMergedIteratorFromDataSources(ds -> ds.iterator());
    }

    @Override
    public Iterator<VariantContext> query(SimpleInterval interval) {
        return this.getMergedIteratorFromDataSources(ds -> ds.queryAndPrefetch(interval).iterator());
    }

    private Iterator<VariantContext> getMergedIteratorFromDataSources(Function<FeatureDataSource<VariantContext>, Iterator<VariantContext>> iteratorFromSource) {
        this.closeOpenIterationIfNecessary();
        if (this.featureDataSources.size() > 1) {
            ArrayList iterators = new ArrayList(this.featureDataSources.size());
            this.featureDataSources.forEach(ds -> iterators.add(this.getCloseableIteratorWrapper((Iterator)iteratorFromSource.apply((FeatureDataSource<VariantContext>)ds))));
            VariantContextComparator varComparator = new VariantContextComparator(this.getSequenceDictionary());
            this.currentIterator = new MergingIterator((Comparator)varComparator, iterators);
        } else {
            this.currentIterator = this.getCloseableIteratorWrapper(iteratorFromSource.apply(this.featureDataSources.get(0)));
        }
        return this.currentIterator;
    }

    public String getName() {
        return "MultiVariantDataSource: (" + Utils.join(", ", this.featureDataSources.stream().map(fds -> fds.getName()).collect(Collectors.toList())) + ")";
    }

    @Override
    public void close() {
        this.closeOpenIterationIfNecessary();
        this.featureDataSources.forEach(dataSource -> dataSource.close());
    }

    private SAMSequenceDictionary getMergedSequenceDictionary(VCFHeader header) {
        return header != null ? header.getSequenceDictionary() : null;
    }

    private SortedSet<String> getSortedSamples() {
        Map<String, VCFHeader> headers = this.featureDataSources.stream().collect(Collectors.toMap(ds -> ds.getName(), ds -> (VCFHeader)ds.getHeader()));
        return VcfUtils.getSortedSampleSet(headers, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
    }

    private VCFHeader getMergedHeader() {
        List headers = this.featureDataSources.stream().map(ds -> this.getHeaderWithUpdatedSequenceDictionary((FeatureDataSource<VariantContext>)ds)).collect(Collectors.toList());
        return headers.size() > 1 ? new VCFHeader(VCFUtils.smartMergeHeaders(headers, (boolean)true)) : (VCFHeader)headers.get(0);
    }

    private VCFHeader getHeaderWithUpdatedSequenceDictionary(FeatureDataSource<VariantContext> dataSource) {
        VCFHeader header = (VCFHeader)dataSource.getHeader();
        SAMSequenceDictionary sourceDict = dataSource.getSequenceDictionary();
        if (header.getSequenceDictionary() == null && sourceDict != null) {
            header.setSequenceDictionary(sourceDict);
        }
        return header;
    }

    private void validateAllSequenceDictionaries() {
        HashMap contigMap = new HashMap();
        this.featureDataSources.forEach(ds -> this.getDataSourceDictionaryAndValidate((FeatureDataSource<VariantContext>)ds, contigMap));
    }

    private void getDataSourceDictionaryAndValidate(FeatureDataSource<VariantContext> ds, Map<String, FeatureDataSource<VariantContext>> contigMap) {
        SAMSequenceDictionary dictionary = ds.getSequenceDictionary();
        if (dictionary == null) {
            logger.warn("A sequence dictionary is required for each input when using multiple inputs, and one could not be obtained for feature input: " + ds.getName() + ". The input may not exist or may not have a valid header");
        } else {
            dictionary.getSequences().forEach(sourceSequence -> this.validateContigAgainstPreviousDataSource((SAMSequenceRecord)sourceSequence, dictionary, contigMap, ds));
        }
    }

    private void validateContigAgainstPreviousDataSource(SAMSequenceRecord sourceSequence, SAMSequenceDictionary dictionary, Map<String, FeatureDataSource<VariantContext>> contigMap, FeatureDataSource<VariantContext> ds) {
        String sourceSequenceName = sourceSequence.getSequenceName();
        FeatureDataSource previousDataSource = contigMap.getOrDefault(sourceSequenceName, null);
        if (previousDataSource != null) {
            SAMSequenceDictionary previousDictionary = previousDataSource.getSequenceDictionary();
            SAMSequenceRecord previousSequence = previousDictionary.getSequence(sourceSequenceName);
            this.validateSequenceDictionaryRecords(ds.getName(), dictionary, sourceSequence, previousDataSource.getName(), previousDictionary, previousSequence);
        } else {
            contigMap.put(sourceSequenceName, ds);
        }
    }

    private void validateSequenceDictionaryRecords(String sourceDataSourceName, SAMSequenceDictionary sourceDictionary, SAMSequenceRecord sourceSequence, String targetDataSourceName, SAMSequenceDictionary targetDictionary, SAMSequenceRecord targetSequence) {
        String sourceMd5;
        if (!SequenceDictionaryUtils.sequenceRecordsAreEquivalent(sourceSequence, targetSequence)) {
            String msg = String.format("Incompatible sequences found (%s: %d) and (%s: %d)", sourceSequence.getSequenceName(), sourceSequence.getSequenceLength(), targetSequence.getSequenceName(), targetSequence.getSequenceLength());
            throw new UserException.IncompatibleSequenceDictionaries(msg, sourceDataSourceName, sourceDictionary, targetDataSourceName, targetDictionary);
        }
        String targetMd5 = targetSequence.getMd5();
        if (Utils.xor(targetMd5 == null, (sourceMd5 = sourceSequence.getMd5()) == null)) {
            String msg = String.format("The MD5 value (%s) for sequence (%s) is present in at least one input sequence dictionary but missing in at least one other input sequence dictionary. In the case where an input VCF contains no embedded sequence dictionary, one may have been derived from the accompanying index; such derived dictionaries do not contain MD5 values and can result in this warning message.", targetMd5 == null ? sourceMd5 : targetMd5, sourceSequence.getSequenceName());
            logger.warn(msg);
        } else if (!Objects.equals(targetMd5, sourceMd5)) {
            String msg = String.format("Incompatible sequence MD5 values found (%s: %s) and (%s: %s)", sourceSequence.getSequenceName(), sourceMd5, targetSequence.getSequenceName(), targetMd5);
            throw new UserException.IncompatibleSequenceDictionaries(msg, sourceDataSourceName, sourceDictionary, targetDataSourceName, targetDictionary);
        }
    }

    private void closeOpenIterationIfNecessary() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
            this.currentIterator = null;
        }
    }

    private CloseableIterator<VariantContext> getCloseableIteratorWrapper(final Iterator<VariantContext> sourceIterator) {
        Utils.nonNull(sourceIterator);
        return new CloseableIterator<VariantContext>(){
            Iterator<VariantContext> delegateIterator;
            {
                this.delegateIterator = sourceIterator;
            }

            public void close() {
                this.delegateIterator = null;
            }

            public boolean hasNext() {
                return this.delegateIterator != null && this.delegateIterator.hasNext();
            }

            public VariantContext next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("hasNext should be called before next");
                }
                return this.delegateIterator.next();
            }
        };
    }

    public SortedSet<String> getSamples() {
        return this.mergedSamples;
    }
}

