/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.Spliterator;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.hellbender.cmdline.argumentcollections.MultiVariantInputArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiVariantDataSource;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class MultiVariantWalker
extends VariantWalkerBase {
    @ArgumentCollection
    protected MultiVariantInputArgumentCollection multiVariantInputArgumentCollection = this.getMultiVariantInputArgumentCollection();
    private MultiVariantDataSource drivingVariants;
    private List<FeatureInput<VariantContext>> drivingVariantsFeatureInputs = new ArrayList<FeatureInput<VariantContext>>(2);

    @Override
    protected SAMSequenceDictionary getSequenceDictionaryForDrivingVariants() {
        return this.drivingVariants.getSequenceDictionary();
    }

    @Override
    protected Spliterator<VariantContext> getSpliteratorForDrivingVariants() {
        return this.drivingVariants.spliterator();
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        if (this.hasUserSuppliedIntervals()) {
            this.drivingVariants.setIntervalsForTraversal(this.userIntervals);
        }
    }

    protected MultiVariantInputArgumentCollection getMultiVariantInputArgumentCollection() {
        return new MultiVariantInputArgumentCollection.DefaultMultiVariantInputArgumentCollection();
    }

    public boolean doDictionaryCrossValidation() {
        return true;
    }

    @Override
    protected void initializeDrivingVariants() {
        boolean skipDictionaryValidation;
        this.multiVariantInputArgumentCollection.getDrivingVariantPaths().stream().forEach(f -> {
            FeatureInput featureInput = new FeatureInput((GATKPath)f);
            if (this.drivingVariantsFeatureInputs.contains(featureInput)) {
                throw new UserException.BadInput("Feature inputs must be unique: " + featureInput.toString());
            }
            this.drivingVariantsFeatureInputs.add(featureInput);
            this.features.addToFeatureSources(0, featureInput, VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.referenceArguments.getReferencePath());
        });
        boolean bl = skipDictionaryValidation = !this.seqValidationArguments.performSequenceDictionaryValidation() || !this.doDictionaryCrossValidation();
        if (skipDictionaryValidation && !this.hasReference() && this.getMasterSequenceDictionary() == null) {
            this.logger.warn("Input feature file dictionaries cannot be validated.  For safety, please specify a reference or a master sequence dictionary with `--sequence-dictionary`");
        }
        this.drivingVariants = new MultiVariantDataSource(this.drivingVariantsFeatureInputs, this.getDrivingVariantCacheLookAheadBases(), this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.referenceArguments.getReferencePath(), skipDictionaryValidation);
    }

    protected final List<FeatureInput<VariantContext>> getDrivingVariantsFeatureInputs() {
        return this.drivingVariantsFeatureInputs;
    }

    @Override
    public final VCFHeader getHeaderForVariants() {
        return this.drivingVariants.getHeader();
    }

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        this.getTransformedVariantStream(this.makeVariantFilter()).forEach(variant -> {
            SimpleInterval variantInterval = new SimpleInterval((Locatable)variant);
            this.apply((VariantContext)variant, new ReadsContext(this.reads, variantInterval, readFilter), new ReferenceContext(this.reference, variantInterval), new FeatureContext(this.features, variantInterval));
            this.progressMeter.update(variantInterval);
        });
    }

    public abstract void apply(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.drivingVariants != null) {
            this.drivingVariants.close();
        }
    }

    public final SortedSet<String> getSamplesForVariants() {
        return this.drivingVariants.getSamples();
    }
}

