/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.MultiVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public abstract class MultiVariantWalkerGroupedOnStart
extends MultiVariantWalker {
    private List<VariantContext> currentVariants = new ArrayList<VariantContext>();
    private int firstCurrentVariantStart;
    private int lastCurrentVariantStart;
    private List<ReadsContext> currentReadsContexts = new ArrayList<ReadsContext>();
    private OverlapDetector<SimpleInterval> overlapDetector;
    public static final String IGNORE_VARIANTS_THAT_START_OUTSIDE_INTERVAL = "ignore-variants-starting-outside-interval";
    public static final String COMBINE_VARIANTS_DISTANCE = "combine-variants-distance";
    public static final String MAX_COMBINED_DISTANCE = "max-distance";
    public static final String REFERENCE_WINDOW_PADDING = "ref-padding";
    @Advanced
    @Argument(fullName="ignore-variants-starting-outside-interval", doc="Restrict variant output to sites that start within provided intervals (only applies when an interval is specified)", optional=true)
    private boolean ignoreIntervalsOutsideStart = false;
    @Advanced
    @Argument(fullName="combine-variants-distance", doc="Maximum distance for variants to be grouped together", optional=true)
    protected int distanceToCombineVariants = this.defaultDistanceToGroupVariants();
    @Advanced
    @Argument(fullName="max-distance", doc="Maximum distance for variants to be grouped together", optional=true)
    protected int maxCombinedDistance = this.defaultMaxGroupedSpan();
    @Advanced
    @Argument(fullName="ref-padding", doc="Number of bases on either side to expand spanning reference window", optional=true)
    protected int referenceWindowPadding = this.defaultReferenceWindowPadding();

    protected int defaultDistanceToGroupVariants() {
        return 0;
    }

    protected int defaultReferenceWindowPadding() {
        return 1;
    }

    protected int defaultMaxGroupedSpan() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public final void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        if (this.ignoreIntervalsOutsideStart && !this.isWithinInterval(new SimpleInterval(variant.getContig(), variant.getStart(), variant.getStart()))) {
            return;
        }
        if (this.currentVariants.isEmpty()) {
            this.firstCurrentVariantStart = variant.getStart();
        } else if (!this.currentVariants.get(0).contigsMatch((Locatable)variant) || this.lastCurrentVariantStart < variant.getStart() - this.distanceToCombineVariants || this.firstCurrentVariantStart < variant.getStart() - this.maxCombinedDistance) {
            this.apply(new ArrayList<VariantContext>(this.currentVariants), this.currentReadsContexts);
            this.currentVariants.clear();
            this.currentReadsContexts.clear();
            this.firstCurrentVariantStart = variant.getStart();
        }
        this.currentVariants.add(variant);
        this.currentReadsContexts.add(readsContext);
        this.lastCurrentVariantStart = variant.getStart();
    }

    public abstract void apply(List<VariantContext> var1, ReferenceContext var2, List<ReadsContext> var3);

    public void apply(List<VariantContext> variantContexts, List<ReadsContext> readsContexts) {
        this.apply(variantContexts, this.makeSpanningReferenceContext(variantContexts, this.referenceWindowPadding), readsContexts);
    }

    private ReferenceContext makeSpanningReferenceContext(List<VariantContext> variantContexts, int referenceWindowPadding) {
        Utils.nonEmpty(variantContexts, "Must have at least one current variant context");
        List contigs = variantContexts.stream().map(VariantContext::getContig).distinct().collect(Collectors.toList());
        Utils.validate(contigs.size() == 1, "variant contexts should all have the same contig");
        int minStart = variantContexts.stream().mapToInt(VariantContext::getStart).min().getAsInt();
        int maxEnd = variantContexts.stream().mapToInt(VariantContext::getEnd).max().getAsInt();
        SimpleInterval combinedInterval = new SimpleInterval((String)contigs.get(0), minStart, maxEnd);
        ReferenceContext combinedReferenceContext = new ReferenceContext(this.reference, combinedInterval);
        combinedReferenceContext.setWindow(referenceWindowPadding, referenceWindowPadding);
        return combinedReferenceContext;
    }

    @Override
    public void traverse() {
        this.beforeTraverse();
        super.traverse();
        this.afterTraverse();
    }

    private void beforeTraverse() {
        this.overlapDetector = this.hasUserSuppliedIntervals() ? OverlapDetector.create(this.intervalArgumentCollection.getIntervals(this.getBestAvailableSequenceDictionary())) : null;
    }

    protected final boolean isWithinInterval(Locatable loc) {
        return this.overlapDetector == null || this.overlapDetector.overlapsAny(loc);
    }

    private void afterTraverse() {
        if (this.currentVariants.isEmpty()) {
            this.logger.warn("Error: The requested interval contained no data in source VCF files");
        } else {
            this.apply(this.currentVariants, this.currentReadsContexts);
        }
    }
}

