/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class MultiplePassReadWalker
extends ReadWalker {
    private CountingReadFilter countedFilter;
    private int passCount = 1;

    public abstract void traverseReads();

    public void forEachRead(GATKReadConsumer readHandler) {
        if (this.passCount > 1) {
            this.countedFilter = this.makeReadFilter();
            this.resetReadsDataSource();
            this.logger.info(String.format("Starting traversal pass %d", this.passCount));
        }
        this.getTransformedReadStream(this.countedFilter).forEach(read -> {
            SimpleInterval readInterval = this.getReadInterval((GATKRead)read);
            readHandler.consume((GATKRead)read, new ReferenceContext(this.reference, readInterval), new FeatureContext(this.features, readInterval));
            this.progressMeter.update(readInterval);
        });
        this.logger.info(this.countedFilter.getSummaryLine());
        ++this.passCount;
    }

    @Override
    public final void traverse() {
        this.countedFilter = this.makeReadFilter();
        this.traverseReads();
    }

    @Override
    public final void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        throw new GATKException("apply can't be called in MultiplePassReadWalker");
    }

    @FunctionalInterface
    public static interface GATKReadConsumer {
        public void consume(GATKRead var1, ReferenceContext var2, FeatureContext var3);
    }
}

