/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.stream.StreamSupport;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.CountingVariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class MultiplePassVariantWalker
extends VariantWalker {
    protected abstract int numberOfPasses();

    @Override
    public void traverse() {
        CountingVariantFilter countingVariantFilter = this.makeVariantFilter();
        CountingReadFilter readFilter = this.makeReadFilter();
        for (int n = 0; n < this.numberOfPasses(); ++n) {
            this.logger.info("Starting pass " + n + " through the variants");
            int nCopyInLambda = n;
            this.traverseVariants(countingVariantFilter, readFilter, (vc, rc, ref, fc) -> this.nthPassApply(vc, rc, ref, fc, nCopyInLambda));
            this.logger.info("Finished pass " + n + " through the variants");
            this.afterNthPass(n);
        }
        this.logger.info(countingVariantFilter.getSummaryLine());
        this.logger.info(readFilter.getSummaryLine());
    }

    protected abstract void nthPassApply(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4, int var5);

    protected abstract void afterNthPass(int var1);

    private void traverseVariants(VariantFilter variantFilter, CountingReadFilter readFilter, VariantConsumer variantConsumer) {
        StreamSupport.stream(this.getSpliteratorForDrivingVariants(), false).filter(variantFilter).forEach(variant -> {
            SimpleInterval variantInterval = new SimpleInterval((Locatable)variant);
            variantConsumer.consume((VariantContext)variant, new ReadsContext(this.reads, variantInterval, readFilter), new ReferenceContext(this.reference, variantInterval), new FeatureContext(this.features, variantInterval));
            this.progressMeter.update(variantInterval);
        });
    }

    @Override
    public final void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
    }

    @FunctionalInterface
    private static interface VariantConsumer {
        public void consume(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);
    }
}

