/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;

public final class ProgressMeter {
    protected static final Logger logger = LogManager.getLogger(ProgressMeter.class);
    public static final double DEFAULT_SECONDS_BETWEEN_UPDATES = 10.0;
    public static final long DEFAULT_RECORDS_BETWEEN_TIME_CHECKS = 1000L;
    public static final LongSupplier DEFAULT_TIME_FUNCTION = System::currentTimeMillis;
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final String DEFAULT_RECORD_LABEL = "records";
    private double secondsBetweenUpdates;
    private long recordsBetweenTimeChecks = 1000L;
    private long numRecordsProcessed = 0L;
    private long startTimeMs = 0L;
    private long currentTimeMs = 0L;
    private long lastPrintTimeMs = 0L;
    private Locatable currentLocus = null;
    private long numLoggerUpdates = 0L;
    private LongSupplier timeFunction;
    private boolean started;
    private boolean stopped;
    private String recordLabel = "records";

    public ProgressMeter() {
        this(10.0);
    }

    public ProgressMeter(double secondsBetweenUpdates) {
        this(secondsBetweenUpdates, DEFAULT_TIME_FUNCTION);
    }

    @VisibleForTesting
    ProgressMeter(double secondsBetweenUpdates, LongSupplier timeFunction) {
        Utils.nonNull(timeFunction);
        Utils.validateArg(secondsBetweenUpdates > 0.0, "secondsBetweenUpdates must be > 0.0");
        this.started = false;
        this.stopped = false;
        this.secondsBetweenUpdates = secondsBetweenUpdates;
        this.timeFunction = timeFunction;
    }

    public void setRecordsBetweenTimeChecks(long recordsBetweenTimeChecks) {
        this.recordsBetweenTimeChecks = recordsBetweenTimeChecks;
    }

    public void setRecordLabel(String label) {
        Utils.nonNull(label);
        this.recordLabel = label;
    }

    public void start() {
        Utils.validate(!this.started, "the progress meter has been started already");
        Utils.validate(!this.stopped, "the progress meter has been stopped already");
        this.started = true;
        logger.info("Starting traversal");
        this.printHeader();
        this.currentTimeMs = this.startTimeMs = this.timeFunction.getAsLong();
        this.lastPrintTimeMs = this.startTimeMs;
        this.numRecordsProcessed = 0L;
        this.numLoggerUpdates = 0L;
        this.currentLocus = null;
    }

    public void update(Locatable currentLocus) {
        Utils.validate(this.started, "the progress meter has not been started yet");
        Utils.validate(!this.stopped, "the progress meter has been stopped already");
        ++this.numRecordsProcessed;
        if (this.numRecordsProcessed % this.recordsBetweenTimeChecks == 0L) {
            this.currentTimeMs = this.timeFunction.getAsLong();
            this.currentLocus = currentLocus;
            if (this.secondsSinceLastPrint() >= this.secondsBetweenUpdates) {
                this.printProgress();
                this.lastPrintTimeMs = this.currentTimeMs;
            }
        }
    }

    public void update(Locatable currentLocus, long recordCountIncrease) {
        Utils.validate(this.started, "the progress meter has not been started yet");
        Utils.validate(!this.stopped, "the progress meter has been stopped already");
        long previousNumRecordsProcessed = this.numRecordsProcessed;
        this.numRecordsProcessed += recordCountIncrease;
        if (previousNumRecordsProcessed / this.recordsBetweenTimeChecks != this.numRecordsProcessed / this.recordsBetweenTimeChecks) {
            this.currentTimeMs = this.timeFunction.getAsLong();
            this.currentLocus = currentLocus;
            if (this.secondsSinceLastPrint() >= this.secondsBetweenUpdates) {
                this.printProgress();
                this.lastPrintTimeMs = this.currentTimeMs;
            }
        }
    }

    public void stop() {
        Utils.validate(this.started, "the progress meter has not been started yet");
        Utils.validate(!this.stopped, "the progress meter has been stopped already");
        this.stopped = true;
        this.currentTimeMs = this.timeFunction.getAsLong();
        this.printProgress();
        logger.info(String.format("Traversal complete. Processed %d total %s in %.1f minutes.", this.numRecordsProcessed, this.recordLabel, this.elapsedTimeInMinutes()));
    }

    private void printHeader() {
        logger.info(String.format("%20s  %15s  %20s  %15s", "Current Locus", "Elapsed Minutes", StringUtils.capitalize((String)this.recordLabel) + " Processed", StringUtils.capitalize((String)this.recordLabel) + "/Minute"));
    }

    private void printProgress() {
        ++this.numLoggerUpdates;
        logger.info(String.format("%20s  %15.1f  %20d  %15.1f", this.currentLocusString(), this.elapsedTimeInMinutes(), this.numRecordsProcessed, this.processingRate()));
    }

    @VisibleForTesting
    double elapsedTimeInMinutes() {
        return (double)(this.currentTimeMs - this.startTimeMs) / 60000.0;
    }

    @VisibleForTesting
    double secondsSinceLastPrint() {
        return (double)(this.currentTimeMs - this.lastPrintTimeMs) / 1000.0;
    }

    @VisibleForTesting
    double processingRate() {
        return (double)this.numRecordsProcessed / this.elapsedTimeInMinutes();
    }

    @VisibleForTesting
    long numLoggerUpdates() {
        return this.numLoggerUpdates;
    }

    private String currentLocusString() {
        return this.currentLocus != null ? this.currentLocus.getContig() + ":" + this.currentLocus.getStart() : "unmapped";
    }

    public boolean started() {
        return this.started;
    }

    public boolean stopped() {
        return this.stopped;
    }
}

