/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;

public class ReadContextData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReferenceBases referenceBases;
    private final List<GATKVariant> variants;

    public ReadContextData(ReferenceBases referenceBases, Iterable<GATKVariant> variants) {
        this.referenceBases = referenceBases;
        this.variants = Lists.newArrayList(variants);
    }

    public ReadContextData(ReferenceBases referenceBases, List<GATKVariant> variants) {
        this.referenceBases = referenceBases;
        this.variants = variants;
    }

    public ReferenceBases getOverlappingReferenceBases() {
        return this.referenceBases;
    }

    public Iterable<GATKVariant> getOverlappingVariants() {
        return this.variants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadContextData that = (ReadContextData)o;
        if (!this.referenceBases.equals(that.referenceBases)) {
            return false;
        }
        return this.variants.equals(that.variants);
    }

    public int hashCode() {
        int result = this.referenceBases.hashCode();
        result = 31 * result + this.variants.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        for (GATKVariant v : this.variants) {
            builder.append(v).append(",");
        }
        builder.append(">");
        return "ReadContextData{referenceBases=" + this.referenceBases.toString() + ", variants=" + builder.toString() + '}';
    }
}

