/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class ReadWalker
extends WalkerBase {
    public static final int FEATURE_CACHE_LOOKAHEAD = 1000;

    @Override
    public boolean requiresReads() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "reads";
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        this.setReadTraversalBounds();
    }

    void setReadTraversalBounds() {
        if (this.hasUserSuppliedIntervals()) {
            this.reads.setTraversalBounds(this.intervalArgumentCollection.getTraversalParameters(this.getHeaderForReads().getSequenceDictionary()));
        }
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 1000, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        if (this.features.isEmpty()) {
            this.features = null;
        }
    }

    @Override
    public void traverse() {
        CountingReadFilter countedFilter = this.makeReadFilter();
        this.getTransformedReadStream(countedFilter).forEach(read -> {
            SimpleInterval readInterval = this.getReadInterval((GATKRead)read);
            this.apply((GATKRead)read, new ReferenceContext(this.reference, readInterval), new FeatureContext(this.features, readInterval));
            this.progressMeter.update(readInterval);
        });
        this.logger.info(countedFilter.getSummaryLine());
    }

    SimpleInterval getReadInterval(GATKRead read) {
        return !read.isUnmapped() && SimpleInterval.isValid(read.getContig(), read.getStart(), read.getEnd()) ? new SimpleInterval(read) : null;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(new WellformedReadFilter());
    }

    public void resetReadsDataSource() {
        if (!this.reads.supportsSerialIteration()) {
            this.reads.close();
            this.initializeReads();
        }
    }

    public abstract void apply(GATKRead var1, ReferenceContext var2, FeatureContext var3);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
    }
}

