/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import java.util.Objects;
import org.broadinstitute.hellbender.engine.AssemblyRegion;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public class ReadlessAssemblyRegion
extends ShardBoundary {
    private static final long serialVersionUID = 1L;
    private final boolean isActive;

    public ReadlessAssemblyRegion(AssemblyRegion assemblyRegion) {
        super(assemblyRegion.getSpan(), assemblyRegion.getPaddedSpan());
        this.isActive = assemblyRegion.isActive();
    }

    private ReadlessAssemblyRegion(SimpleInterval activeRegionLoc, SimpleInterval paddedSpan, boolean isActive, boolean padded) {
        super(activeRegionLoc, paddedSpan, padded);
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public ShardBoundary paddedShardBoundary() {
        return this.padded ? this : new ReadlessAssemblyRegion(this.interval, this.paddedSpan, this.isActive, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReadlessAssemblyRegion that = (ReadlessAssemblyRegion)o;
        return this.isActive == that.isActive;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isActive);
    }

    @Override
    public String toString() {
        return "ReadlessAssemblyRegion{isActive=" + this.isActive + ", interval=" + this.interval + ", paddedSpan=" + this.paddedSpan + ", padded=" + this.padded + '}';
    }
}

