/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import java.util.Collections;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.iterators.ReadFilteringIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class ReadsContext
implements Iterable<GATKRead> {
    private final GATKDataSource<GATKRead> dataSource;
    private final SimpleInterval interval;
    private final ReadFilter readFilter;

    public ReadsContext() {
        this(null, null, null);
    }

    public ReadsContext(GATKDataSource<GATKRead> dataSource, SimpleInterval interval) {
        this(dataSource, interval, null);
    }

    public ReadsContext(GATKDataSource<GATKRead> dataSource, SimpleInterval interval, ReadFilter readFilter) {
        this.dataSource = dataSource;
        this.interval = interval;
        this.readFilter = readFilter;
    }

    public ReadsContext(ReadsContext readsContext, SimpleInterval interval) {
        this(readsContext.dataSource, interval, readsContext.readFilter);
    }

    public boolean hasBackingDataSource() {
        return this.dataSource != null;
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    @Override
    public Iterator<GATKRead> iterator() {
        return this.iterator(this.interval);
    }

    public Iterator<GATKRead> iterator(SimpleInterval interval) {
        if (this.dataSource == null || interval == null) {
            return Collections.emptyList().iterator();
        }
        return this.readFilter == null ? this.dataSource.query(interval) : new ReadFilteringIterator(this.dataSource.query(interval), this.readFilter);
    }
}

