/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.engine.TraversalParameters;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public interface ReadsDataSource
extends GATKDataSource<GATKRead>,
AutoCloseable {
    public void setTraversalBounds(List<SimpleInterval> var1, boolean var2);

    default public void setTraversalBounds(List<SimpleInterval> intervals) {
        this.setTraversalBounds(intervals, false);
    }

    default public void setTraversalBounds(TraversalParameters traversalParameters) {
        this.setTraversalBounds(traversalParameters.getIntervalsForTraversal(), traversalParameters.traverseUnmappedReads());
    }

    public boolean traversalIsBounded();

    public boolean isQueryableByInterval();

    public Iterator<GATKRead> queryUnmapped();

    public SAMFileHeader getHeader();

    default public SAMSequenceDictionary getSequenceDictionary() {
        return this.getHeader().getSequenceDictionary();
    }

    public boolean supportsSerialIteration();

    @Override
    public void close();
}

