/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SamReaderFactory;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.broadinstitute.hellbender.engine.ReadsPathDataSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.AutoCloseableReference;

public final class ReadsDataSourcePool
extends GenericObjectPool<ReadsPathDataSource>
implements AutoCloseable {
    public ReadsDataSourcePool(List<Path> readPaths, Path referencePath) {
        super((PoolableObjectFactory)new Factory(readPaths, referencePath));
        this.setWhenExhaustedAction((byte)2);
    }

    public AutoCloseableReference<ReadsPathDataSource> borrowAutoReturn() {
        return AutoCloseableReference.of(this.borrowObject(), this::returnObject);
    }

    public ReadsPathDataSource borrowObject() {
        try {
            return (ReadsPathDataSource)super.borrowObject();
        }
        catch (Exception e) {
            throw new GATKException(e.getMessage(), e);
        }
    }

    public void returnObject(ReadsPathDataSource dataSource) {
        try {
            super.returnObject((Object)dataSource);
        }
        catch (Exception e) {
            throw new GATKException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception ex) {
            throw new GATKException("exception when closing the pool", ex);
        }
    }

    private static class Factory
    extends BasePoolableObjectFactory<ReadsPathDataSource> {
        private final List<Path> paths;
        private final Path referencePath;

        private Factory(List<Path> paths, Path referencePath) {
            this.paths = paths;
            this.referencePath = referencePath;
        }

        public ReadsPathDataSource makeObject() {
            SamReaderFactory factory = SamReaderFactory.makeDefault();
            if (this.referencePath != null) {
                factory.referenceSequence(this.referencePath);
            }
            return new ReadsPathDataSource(this.paths, factory);
        }

        public void destroyObject(ReadsPathDataSource dataSource) {
            dataSource.close();
        }

        public boolean validateObject(ReadsPathDataSource dataSource) {
            return !dataSource.isClosed();
        }
    }
}

