/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Locatable;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.BasicReference;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.ByteArrayIterator;

public final class ReferenceContext
implements Iterable<Byte>,
Locatable,
BasicReference {
    private final ReferenceDataSource dataSource;
    private final SimpleInterval interval;
    private SimpleInterval window;
    private ReferenceSequence cachedSequence;

    public ReferenceContext() {
        this(null, null, 0, 0);
    }

    public ReferenceContext(ReferenceDataSource dataSource, SimpleInterval interval) {
        this(dataSource, interval, 0, 0);
    }

    public ReferenceContext(ReferenceDataSource dataSource, SimpleInterval interval, int windowLeadingBases, int windowTrailingBases) {
        this.dataSource = dataSource;
        this.cachedSequence = null;
        this.interval = interval;
        this.setWindow(windowLeadingBases, windowTrailingBases);
    }

    public ReferenceContext(ReferenceContext thatContext, SimpleInterval interval) {
        this.dataSource = thatContext.dataSource;
        this.cachedSequence = null;
        this.interval = interval;
        int windowLeadingBases = thatContext.numWindowLeadingBases();
        int windowTrailingBases = thatContext.numWindowTrailingBases();
        this.setWindow(windowLeadingBases, windowTrailingBases);
    }

    public ReferenceContext(ReferenceDataSource dataSource, SimpleInterval interval, SimpleInterval window) {
        this.dataSource = dataSource;
        this.cachedSequence = null;
        this.interval = interval;
        Utils.validateArg(interval != null || window == null, () -> "if interval is null then window must be null too but was " + window);
        Utils.validateArg(interval == null || window == null || window.contains(interval), () -> "window " + window + " does not contain the interval " + interval);
        this.window = window == null ? interval : new SimpleInterval(interval.getContig(), this.trimToContigStart(window.getStart()), this.trimToContigLength(interval.getContig(), window.getEnd()));
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    public SAMSequenceRecord getSequenceRecord() {
        return this.dataSource != null ? this.dataSource.getSequenceDictionary().getSequence(this.getContig()) : null;
    }

    public boolean hasBackingDataSource() {
        return this.dataSource != null;
    }

    @Override
    public Iterator<Byte> iterator() {
        return this.dataSource != null && this.window != null ? this.dataSource.query(this.window) : new ByteArrayIterator(new byte[0]);
    }

    public byte[] getBases() {
        if (this.dataSource == null || this.window == null) {
            return new byte[0];
        }
        if (this.cachedSequence == null) {
            this.cachedSequence = this.dataSource.queryAndPrefetch(this.window);
        }
        return this.cachedSequence.getBases();
    }

    @Override
    public byte[] getBases(SimpleInterval window) {
        if (this.dataSource == null || window == null) {
            return new byte[0];
        }
        SimpleInterval trimmedWindow = new SimpleInterval(window.getContig(), this.trimToContigStart(window.getStart()), this.trimToContigLength(window.getContig(), window.getEnd()));
        return this.dataSource.queryAndPrefetch(trimmedWindow).getBases();
    }

    public byte[] getBases(int windowLeadingBases, int windowTrailingBases) {
        if (this.dataSource == null || this.window == null) {
            return new byte[0];
        }
        SimpleInterval trimmedWindow = new SimpleInterval(this.window.getContig(), this.trimToContigStart(this.window.getStart() - windowLeadingBases), this.trimToContigLength(this.window.getContig(), this.window.getEnd() + windowTrailingBases));
        return this.dataSource.queryAndPrefetch(trimmedWindow).getBases();
    }

    public byte[] getForwardBases() {
        byte[] bases = this.getBases();
        int mid = this.interval.getStart() - this.window.getStart();
        return new String(bases).substring(mid).getBytes();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public SimpleInterval getWindow() {
        return this.window;
    }

    public void setWindow(int windowLeadingBases, int windowTrailingBases) {
        if (windowLeadingBases < 0) {
            throw new GATKException("Reference window starts after the current interval");
        }
        if (windowTrailingBases < 0) {
            throw new GATKException("Reference window ends before the current interval");
        }
        this.window = this.interval == null || windowLeadingBases == 0 && windowTrailingBases == 0 ? this.interval : new SimpleInterval(this.interval.getContig(), this.calculateWindowStart(this.interval, windowLeadingBases), this.calculateWindowStop(this.interval, windowTrailingBases));
        this.cachedSequence = null;
    }

    public int numWindowLeadingBases() {
        return this.window == null ? 0 : this.interval.getStart() - this.window.getStart();
    }

    public int numWindowTrailingBases() {
        return this.window == null ? 0 : this.window.getEnd() - this.interval.getEnd();
    }

    private int calculateWindowStart(SimpleInterval locus, int windowLeadingBases) {
        return this.trimToContigStart(locus.getStart() - windowLeadingBases);
    }

    private int trimToContigStart(int start) {
        return Math.max(start, 1);
    }

    private int calculateWindowStop(SimpleInterval locus, int windowTrailingBases) {
        return this.trimToContigLength(locus.getContig(), locus.getEnd() + windowTrailingBases);
    }

    private int trimToContigLength(String contig, int end) {
        SAMSequenceRecord sequence = this.dataSource.getSequenceDictionary().getSequence(contig);
        if (sequence == null) {
            throw new UserException("Given reference file does not have data at the requested contig(" + contig + ")!");
        }
        int sequenceLength = this.dataSource.getSequenceDictionary().getSequence(contig).getSequenceLength();
        return Math.min(end, sequenceLength);
    }

    private int getContigLength(String contig) {
        return this.dataSource.getSequenceDictionary().getSequence(contig).getSequenceLength();
    }

    public byte getBase() {
        return this.getBases()[this.interval.getStart() - this.window.getStart()];
    }

    public String getKmerAround(int center, int numBasesOnEachSide) {
        Utils.validateArg(center >= 1, () -> "start position must be positive");
        Utils.validateArg(this.window.getStart() <= center && center <= this.window.getEnd(), "position must be smaller than end position");
        SimpleInterval newWindow = new SimpleInterval(this.window.getContig(), center, center).expandWithinContig(numBasesOnEachSide, this.getContigLength(this.window.getContig()));
        if (newWindow.getEnd() - newWindow.getStart() < 2 * numBasesOnEachSide) {
            return null;
        }
        return new String(this.getBases(newWindow));
    }
}

