/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import java.nio.file.Path;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.GATKDataSource;
import org.broadinstitute.hellbender.engine.ReferenceFileSource;
import org.broadinstitute.hellbender.engine.ReferenceMemorySource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.iterators.ByteArrayIterator;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public interface ReferenceDataSource
extends GATKDataSource<Byte>,
AutoCloseable {
    public static ReferenceDataSource of(Path fastaPath) {
        return new ReferenceFileSource(fastaPath);
    }

    public static ReferenceDataSource of(Path fastaPath, boolean preserveAmbiguityCodesAndCapitalization) {
        return new ReferenceFileSource(fastaPath, preserveAmbiguityCodesAndCapitalization);
    }

    public static ReferenceDataSource of(ReferenceBases bases, SAMSequenceDictionary referenceSequenceDictionary) {
        return new ReferenceMemorySource(bases, referenceSequenceDictionary);
    }

    default public ReferenceSequence queryAndPrefetch(SimpleInterval interval) {
        return this.queryAndPrefetch(interval.getContig(), interval.getStart(), interval.getEnd());
    }

    public ReferenceSequence queryAndPrefetch(String var1, long var2, long var4);

    @Override
    default public Iterator<Byte> query(SimpleInterval interval) {
        return new ByteArrayIterator(this.queryAndPrefetch(interval).getBases());
    }

    public SAMSequenceDictionary getSequenceDictionary();

    @Override
    default public void close() {
    }
}

