/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import java.nio.file.Path;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;

public final class ReferenceFileSource
implements ReferenceDataSource {
    private final CachingIndexedFastaSequenceFile reference;

    public ReferenceFileSource(Path fastaPath) {
        this.reference = new CachingIndexedFastaSequenceFile(Utils.nonNull(fastaPath));
    }

    public ReferenceFileSource(Path fastaPath, boolean preserveFileBases) {
        this.reference = new CachingIndexedFastaSequenceFile(Utils.nonNull(fastaPath), preserveFileBases);
    }

    @Override
    public Iterator<Byte> iterator() {
        throw new UnsupportedOperationException("Iteration over entire reference not yet implemented");
    }

    @Override
    public ReferenceSequence queryAndPrefetch(String contig, long start, long stop) {
        return this.reference.getSubsequenceAt(contig, start, stop);
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.reference.getSequenceDictionary();
    }

    @Override
    public void close() {
        this.reference.close();
    }
}

