/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import java.util.Arrays;
import java.util.Iterator;
import org.broadinstitute.hellbender.engine.ReferenceDataSource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.ByteArrayIterator;
import org.broadinstitute.hellbender.utils.reference.ReferenceBases;

public final class ReferenceMemorySource
implements ReferenceDataSource {
    private final ReferenceBases bases;
    private final SAMSequenceDictionary sequenceDictionary;

    public ReferenceMemorySource(ReferenceBases bases, SAMSequenceDictionary referenceSequenceDictionary) {
        this.bases = Utils.nonNull(bases);
        this.sequenceDictionary = referenceSequenceDictionary;
    }

    @Override
    public Iterator<Byte> iterator() {
        throw new UnsupportedOperationException("Iteration over entire reference not yet implemented");
    }

    @Override
    public Iterator<Byte> query(SimpleInterval interval) {
        int startIndex = interval.getStart() - this.bases.getInterval().getStart();
        int stopIndex = startIndex + interval.size();
        return new ByteArrayIterator(this.bases.getBases(), startIndex, stopIndex);
    }

    @Override
    public ReferenceSequence queryAndPrefetch(SimpleInterval interval) {
        return this.queryAndPrefetch(interval.getContig(), interval.getStart(), interval.getEnd());
    }

    @Override
    public ReferenceSequence queryAndPrefetch(String contig, long start, long stop) {
        int contigIndex = this.sequenceDictionary.getSequenceIndex(contig);
        int startIndex = (int)(start - (long)this.bases.getInterval().getStart());
        int length = (int)(stop - start + 1L);
        byte[] basesBytes = this.bases.getBases();
        if (startIndex == 0 && length == basesBytes.length) {
            return new ReferenceSequence(contig, contigIndex, basesBytes);
        }
        Utils.validIndex(startIndex, basesBytes.length);
        Utils.validateArg(startIndex + length <= basesBytes.length, () -> String.format("Asking for stop %d on contig %s but the ReferenceData only has data until %d.", stop, contig, this.bases.getInterval().getEnd()));
        Utils.validateArg(length >= 0, () -> String.format("Asking for stop<start (%d < %d)", stop, start));
        return new ReferenceSequence(contig, contigIndex, Arrays.copyOfRange(basesBytes, startIndex, startIndex + length));
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public void close() {
    }
}

