/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import java.io.Serializable;
import org.broadinstitute.hellbender.utils.Utils;

public final class ReferenceShard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int shardNumber;
    private final String contig;
    public static final int REFERENCE_SHARD_SIZE = 10000;

    public ReferenceShard(int shardNumber, String contig) {
        this.shardNumber = shardNumber;
        this.contig = Utils.nonNull(contig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceShard that = (ReferenceShard)o;
        if (this.getShardNumber() != that.getShardNumber()) {
            return false;
        }
        return this.getContig().equals(that.getContig());
    }

    public int hashCode() {
        int result = this.getShardNumber();
        result = 5779 * result + this.getContig().hashCode();
        return result;
    }

    public String getContig() {
        return this.contig;
    }

    public int getShardNumber() {
        return this.shardNumber;
    }

    public String toString() {
        return "ReferenceShard{shardNumber=" + this.shardNumber + ", contig='" + this.contig + '\'' + '}';
    }

    public static ReferenceShard getShardNumberFromInterval(Locatable location) {
        return new ReferenceShard(location.getStart() / 10000, location.getContig());
    }
}

