/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;

public abstract class ReferenceWalker
extends WalkerBase {
    @Override
    public String getProgressMeterRecordLabel() {
        return "bases";
    }

    @Override
    public final boolean requiresReference() {
        return true;
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
    }

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        for (SimpleInterval locus : this.getIntervalIterator()) {
            SimpleInterval referenceWindow = this.getReferenceWindow(locus);
            ReferenceContext referenceContext = new ReferenceContext(this.reference, locus, referenceWindow);
            this.apply(referenceContext, new ReadsContext(this.reads, referenceContext.getWindow(), readFilter), new FeatureContext(this.features, referenceContext.getWindow()));
            this.progressMeter.update(referenceContext.getInterval());
        }
    }

    protected SimpleInterval getReferenceWindow(SimpleInterval locus) {
        return locus;
    }

    private Iterable<SimpleInterval> getIntervalIterator() {
        return () -> new IntervalLocusIterator(this.getTraversalIntervals().iterator());
    }

    public abstract void apply(ReferenceContext var1, ReadsContext var2, FeatureContext var3);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
    }
}

