/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.engine.ShardBoundary;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public interface Shard<T>
extends Iterable<T>,
Locatable {
    public SimpleInterval getInterval();

    public SimpleInterval getPaddedInterval();

    default public int getStart() {
        return this.getInterval().getStart();
    }

    default public int getEnd() {
        return this.getInterval().getEnd();
    }

    default public String getContig() {
        return this.getInterval().getContig();
    }

    public static List<ShardBoundary> divideIntervalIntoShards(SimpleInterval interval, int shardSize, int shardPadding, SAMSequenceDictionary dictionary) {
        return Shard.divideIntervalIntoShards(interval, shardSize, shardSize, shardPadding, dictionary);
    }

    public static List<ShardBoundary> divideIntervalIntoShards(SimpleInterval interval, int shardSize, int shardStep, int shardPadding, SAMSequenceDictionary dictionary) {
        Utils.nonNull(interval);
        Utils.nonNull(dictionary);
        Utils.validateArg(shardSize >= 1, "shardSize must be >= 1");
        Utils.validateArg(shardStep >= 1, "shardStep must be >= 1");
        Utils.validateArg(shardPadding >= 0, "shardPadding must be >= 0");
        Utils.validateArg(IntervalUtils.intervalIsOnDictionaryContig(interval, dictionary), () -> "Interval " + interval + " not within the bounds of a contig in the provided dictionary");
        ArrayList<ShardBoundary> shards = new ArrayList<ShardBoundary>();
        for (int start = interval.getStart(); start <= interval.getEnd(); start += shardStep) {
            int end = Math.min(start + shardSize - 1, interval.getEnd());
            SimpleInterval nextShardInterval = new SimpleInterval(interval.getContig(), start, end);
            SimpleInterval nextShardIntervalPadded = nextShardInterval.expandWithinContig(shardPadding, dictionary);
            shards.add(new ShardBoundary(nextShardInterval, nextShardIntervalPadded));
        }
        return shards;
    }
}

