/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import java.io.Serializable;
import java.util.Objects;
import org.broadinstitute.hellbender.engine.Shard;
import org.broadinstitute.hellbender.engine.ShardBoundaryShard;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class ShardBoundary
implements Locatable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final SimpleInterval interval;
    protected final SimpleInterval paddedSpan;
    protected final boolean padded;

    public ShardBoundary(SimpleInterval interval, SimpleInterval paddedSpan) {
        this(interval, paddedSpan, false);
    }

    protected ShardBoundary(SimpleInterval interval, SimpleInterval paddedSpan, boolean padded) {
        Utils.nonNull(interval);
        Utils.nonNull(paddedSpan);
        Utils.validateArg(paddedSpan.contains(interval), "interval must be contained within paddedSpan");
        this.interval = interval;
        this.paddedSpan = paddedSpan;
        this.padded = padded;
    }

    public String getContig() {
        return (this.padded ? this.paddedSpan : this.interval).getContig();
    }

    public int getStart() {
        return (this.padded ? this.paddedSpan : this.interval).getStart();
    }

    public int getEnd() {
        return (this.padded ? this.paddedSpan : this.interval).getEnd();
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public SimpleInterval getPaddedSpan() {
        return this.paddedSpan;
    }

    public ShardBoundary paddedShardBoundary() {
        return this.padded ? this : new ShardBoundary(this.interval, this.paddedSpan, true);
    }

    public <T> Shard<T> createShard(Iterable<T> locatables) {
        return new ShardBoundaryShard<T>(this, locatables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardBoundary key = (ShardBoundary)o;
        if (!Objects.equals(this.interval, key.interval)) {
            return false;
        }
        return Objects.equals(this.paddedSpan, key.paddedSpan);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.paddedSpan);
    }

    public String toString() {
        return "ShardBoundary{interval=" + this.interval + ", paddedSpan=" + this.paddedSpan + ", padded=" + this.padded + '}';
    }
}

