/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.MultiplePassVariantWalker;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;

public abstract class TwoPassVariantWalker
extends MultiplePassVariantWalker {
    @Override
    protected final int numberOfPasses() {
        return 2;
    }

    @Override
    protected final void nthPassApply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext, int n) {
        if (n == 0) {
            this.firstPassApply(variant, readsContext, referenceContext, featureContext);
        } else if (n == 1) {
            this.secondPassApply(variant, readsContext, referenceContext, featureContext);
        } else {
            throw new GATKException.ShouldNeverReachHereException("This two-pass walker should never reach (zero-indexed) pass " + n);
        }
    }

    @Override
    protected final void afterNthPass(int n) {
        if (n == 0) {
            this.afterFirstPass();
        } else if (n > 1) {
            throw new GATKException.ShouldNeverReachHereException("This two-pass walker should never reach (zero-indexed) pass " + n);
        }
    }

    protected abstract void firstPassApply(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);

    protected abstract void afterFirstPass();

    protected abstract void secondPassApply(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);
}

