/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.engine.filters.CountingVariantFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.transformers.VariantTransformer;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;
import org.broadinstitute.hellbender.utils.iterators.ShardedIntervalIterator;

public abstract class VariantLocusWalker
extends VariantWalkerBase {
    @Argument(fullName="variant", shortName="V", doc="A VCF file containing variants", common=false, optional=false)
    public String drivingVariantFile;
    private FeatureDataSource<VariantContext> drivingVariants;
    private FeatureInput<VariantContext> drivingVariantsFeatureInput;
    private boolean traverseByVariant = false;

    protected void changeTraversalModeToByVariant() {
        this.traverseByVariant = true;
    }

    @Override
    protected SAMSequenceDictionary getSequenceDictionaryForDrivingVariants() {
        return this.drivingVariants.getSequenceDictionary();
    }

    @Override
    protected Spliterator<VariantContext> getSpliteratorForDrivingVariants() {
        return this.drivingVariants.spliterator();
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        if (this.hasUserSuppliedIntervals()) {
            this.drivingVariants.setIntervalsForTraversal(this.userIntervals);
        }
    }

    @Override
    protected void initializeDrivingVariants() {
        this.drivingVariantsFeatureInput = new FeatureInput(this.drivingVariantFile, "drivingVariantFile");
        this.drivingVariants = new FeatureDataSource<VariantContext>(this.drivingVariantsFeatureInput, this.getDrivingVariantCacheLookAheadBases(), VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        this.features.addToFeatureSources(0, this.drivingVariantsFeatureInput, VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
    }

    protected final FeatureInput<VariantContext> getDrivingVariantsFeatureInput() {
        return this.drivingVariantsFeatureInput;
    }

    @Override
    public final VCFHeader getHeaderForVariants() {
        Object header = this.drivingVariants.getHeader();
        if (!(header instanceof VCFHeader)) {
            throw new GATKException("Header for " + this.drivingVariantFile + " is not in VCF header format");
        }
        return (VCFHeader)header;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        CountingVariantFilter variantFilter = this.makeVariantFilter();
        VariantTransformer preTransformer = this.makePreVariantFilterTransformer();
        VariantTransformer postTransformer = this.makePostVariantFilterTransformer();
        if (this.traverseByVariant) {
            this.getTransformedVariantStream(this.getSpliteratorForDrivingVariants(), preTransformer, variantFilter, postTransformer).forEachOrdered(variant -> {
                SimpleInterval variantInterval = new SimpleInterval((Locatable)variant);
                this.apply((Locatable)variant, Collections.singletonList(variant), new ReadsContext(this.reads, variantInterval, readFilter), new ReferenceContext(this.reference, variantInterval), new FeatureContext(this.features, variantInterval));
                this.progressMeter.update(variantInterval);
            });
        } else {
            Utils.stream(new ShardedIntervalIterator(this.getTraversalIntervals().iterator(), this.getDrivingVariantCacheLookAheadBases())).forEachOrdered(shard -> {
                if (this.drivingVariants.query((SimpleInterval)shard).hasNext()) {
                    this.getLocusStream(new SimpleInterval((Locatable)shard)).forEachOrdered(locus -> {
                        List<VariantContext> filteredVariants;
                        Iterator<VariantContext> overlappingVariants = this.drivingVariants.query((SimpleInterval)locus);
                        if (overlappingVariants.hasNext() && !(filteredVariants = this.getTransformedVariantStream(Spliterators.spliteratorUnknownSize(overlappingVariants, 0), preTransformer, variantFilter, postTransformer).collect(Collectors.toList())).isEmpty()) {
                            this.apply((Locatable)locus, filteredVariants, new ReadsContext(this.reads, (SimpleInterval)locus, readFilter), new ReferenceContext(this.reference, (SimpleInterval)locus), new FeatureContext(this.features, (SimpleInterval)locus));
                            this.progressMeter.update((Locatable)locus);
                        }
                    });
                }
            });
        }
    }

    private Stream<SimpleInterval> getLocusStream(SimpleInterval requestedInterval) {
        return Utils.stream(new IntervalLocusIterator(Collections.singletonList(requestedInterval).iterator()));
    }

    public abstract void apply(Locatable var1, List<VariantContext> var2, ReadsContext var3, ReferenceContext var4, FeatureContext var5);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.drivingVariants != null) {
            this.drivingVariants.close();
        }
    }
}

