/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public final class VariantShard {
    private final int shardNumber;
    private final String contig;
    public static final int VARIANT_SHARDSIZE = 1000;

    public VariantShard(int shardNumber, String contig) {
        this.shardNumber = shardNumber;
        this.contig = Utils.nonNull(contig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantShard that = (VariantShard)o;
        return this.getShardNumber() == that.getShardNumber() && this.getContig().equals(that.getContig());
    }

    public int hashCode() {
        int result = this.getShardNumber();
        result = 5779 * result + this.getContig().hashCode();
        return result;
    }

    public String getContig() {
        return this.contig;
    }

    public int getShardNumber() {
        return this.shardNumber;
    }

    public static List<VariantShard> getVariantShardsFromInterval(Locatable location) {
        if (location.getContig() == null) {
            throw new GATKException("getVariantShardsFromInterval requires locations to be mapped");
        }
        ArrayList<VariantShard> shardList = new ArrayList<VariantShard>();
        int startShard = location.getStart() / 1000;
        int endShard = location.getEnd() / 1000;
        for (int i = startShard; i <= endShard; ++i) {
            shardList.add(new VariantShard(i, location.getContig()));
        }
        return shardList;
    }

    public String toString() {
        return "VariantShard{shardNumber=" + this.shardNumber + ", contig='" + this.contig + '\'' + '}';
    }
}

