/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Spliterator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingReadFilter;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public abstract class VariantWalker
extends VariantWalkerBase {
    @Argument(fullName="variant", shortName="V", doc="A VCF file containing variants", common=false, optional=false)
    public GATKPath drivingVariantFile;
    private FeatureDataSource<VariantContext> drivingVariants;
    private FeatureInput<VariantContext> drivingVariantsFeatureInput;

    @Override
    protected SAMSequenceDictionary getSequenceDictionaryForDrivingVariants() {
        return this.drivingVariants.getSequenceDictionary();
    }

    @Override
    protected Spliterator<VariantContext> getSpliteratorForDrivingVariants() {
        return this.drivingVariants.spliterator();
    }

    @Override
    protected final void onStartup() {
        super.onStartup();
        if (this.hasUserSuppliedIntervals()) {
            this.drivingVariants.setIntervalsForTraversal(this.userIntervals);
        }
    }

    @Override
    protected void initializeDrivingVariants() {
        this.drivingVariantsFeatureInput = new FeatureInput(this.drivingVariantFile, "drivingVariantFile");
        this.drivingVariants = new FeatureDataSource<VariantContext>(this.drivingVariantsFeatureInput, this.getDrivingVariantCacheLookAheadBases(), VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        this.features.addToFeatureSources(0, this.drivingVariantsFeatureInput, VariantContext.class, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
    }

    protected final FeatureInput<VariantContext> getDrivingVariantsFeatureInput() {
        return this.drivingVariantsFeatureInput;
    }

    @Override
    public final VCFHeader getHeaderForVariants() {
        Object header = this.drivingVariants.getHeader();
        if (!(header instanceof VCFHeader)) {
            throw new GATKException("Header for " + this.drivingVariantFile + " is not in VCF header format");
        }
        return (VCFHeader)header;
    }

    @Override
    public void traverse() {
        CountingReadFilter readFilter = this.makeReadFilter();
        this.getTransformedVariantStream(this.makeVariantFilter()).forEach(variant -> {
            SimpleInterval variantInterval = new SimpleInterval((Locatable)variant);
            this.apply((VariantContext)variant, new ReadsContext(this.reads, variantInterval, readFilter), new ReferenceContext(this.reference, variantInterval), new FeatureContext(this.features, variantInterval));
            this.progressMeter.update(variantInterval);
        });
    }

    public abstract void apply(VariantContext var1, ReadsContext var2, ReferenceContext var3, FeatureContext var4);

    @Override
    protected final void onShutdown() {
        super.onShutdown();
        if (this.drivingVariants != null) {
            this.drivingVariants.close();
        }
    }
}

