/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.broadinstitute.hellbender.engine.FeatureManager;
import org.broadinstitute.hellbender.engine.WalkerBase;
import org.broadinstitute.hellbender.engine.filters.CountingVariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilterLibrary;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.transformers.VariantTransformer;
import org.broadinstitute.hellbender.utils.IndexUtils;

public abstract class VariantWalkerBase
extends WalkerBase {
    public static final int DEFAULT_DRIVING_VARIANTS_LOOKAHEAD_BASES = 100000;
    protected GenomicsDBOptions genomicsDBOptions;

    @Override
    public boolean requiresFeatures() {
        return true;
    }

    @Override
    public String getProgressMeterRecordLabel() {
        return "variants";
    }

    @Override
    protected GenomicsDBOptions getGenomicsDBOptions() {
        if (this.genomicsDBOptions == null) {
            this.genomicsDBOptions = new GenomicsDBOptions(this.referenceArguments.getReferencePath());
        }
        return this.genomicsDBOptions;
    }

    @Override
    void initializeFeatures() {
        this.features = new FeatureManager(this, 100000, this.cloudPrefetchBuffer, this.cloudIndexPrefetchBuffer, this.getGenomicsDBOptions());
        this.initializeDrivingVariants();
    }

    @Override
    public SAMSequenceDictionary getBestAvailableSequenceDictionary() {
        SAMSequenceDictionary dictFromDrivingVariants = this.getSequenceDictionaryForDrivingVariants();
        if (dictFromDrivingVariants != null) {
            if (IndexUtils.isSequenceDictionaryFromIndex(dictFromDrivingVariants)) {
                SAMSequenceDictionary otherDictionary = super.getBestAvailableSequenceDictionary();
                return otherDictionary != null ? otherDictionary : dictFromDrivingVariants;
            }
            return dictFromDrivingVariants;
        }
        return super.getBestAvailableSequenceDictionary();
    }

    protected abstract void initializeDrivingVariants();

    public abstract VCFHeader getHeaderForVariants();

    protected abstract SAMSequenceDictionary getSequenceDictionaryForDrivingVariants();

    protected abstract Spliterator<VariantContext> getSpliteratorForDrivingVariants();

    protected int getDrivingVariantCacheLookAheadBases() {
        return 100000;
    }

    public VariantTransformer makePreVariantFilterTransformer() {
        return VariantTransformer.identity();
    }

    public VariantTransformer makePostVariantFilterTransformer() {
        return VariantTransformer.identity();
    }

    protected Stream<VariantContext> getTransformedVariantStream(CountingVariantFilter filter) {
        VariantTransformer preTransformer = this.makePreVariantFilterTransformer();
        VariantTransformer postTransformer = this.makePostVariantFilterTransformer();
        return this.getTransformedVariantStream(this.getSpliteratorForDrivingVariants(), preTransformer, filter, postTransformer);
    }

    protected Stream<VariantContext> getTransformedVariantStream(Spliterator<VariantContext> source, VariantTransformer preTransformer, CountingVariantFilter filter, VariantTransformer postTransformer) {
        return StreamSupport.stream(source, false).map(preTransformer).filter(filter).map(postTransformer);
    }

    protected CountingVariantFilter makeVariantFilter() {
        return new CountingVariantFilter(VariantFilterLibrary.ALLOW_ALL_VARIANTS);
    }
}

