/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filters out reads where the alignment does not match the contents of the header")
public final class AlignmentAgreesWithHeaderReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public AlignmentAgreesWithHeaderReadFilter() {
    }

    public AlignmentAgreesWithHeaderReadFilter(SAMFileHeader header) {
        super.setHeader(header);
    }

    @Override
    public boolean test(GATKRead read) {
        return ReadUtils.alignmentAgreesWithHeader(this.samHeader, read);
    }
}

