/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filters out reads that have greater than the threshold number of N bases")
public final class AmbiguousBaseReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    @Argument(doc="Threshold fraction of ambiguous bases", fullName="ambig-filter-frac", optional=true, mutex={"ambig-filter-bases"})
    public double maxAmbiguousBaseFraction = 0.05;
    @Argument(doc="Threshold number of ambiguous bases. If null, uses threshold fraction; otherwise, overrides threshold fraction.", fullName="ambig-filter-bases", optional=true, mutex={"ambig-filter-frac"})
    public Integer maxAmbiguousBases = null;

    public AmbiguousBaseReadFilter() {
    }

    public AmbiguousBaseReadFilter(int maxAmbiguousBases) {
        this.maxAmbiguousBases = maxAmbiguousBases;
    }

    @Override
    public boolean test(GATKRead read) {
        int maxN = this.maxAmbiguousBases != null ? this.maxAmbiguousBases : (int)((double)read.getLength() * this.maxAmbiguousBaseFraction);
        int numN = 0;
        for (byte base : read.getBases()) {
            if (BaseUtils.isRegularBase(base) || ++numN <= maxN) continue;
            return false;
        }
        return true;
    }
}

