/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import java.util.List;
import java.util.Stack;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class CountingReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    protected final ReadFilter delegateFilter;
    protected long filteredCount = 0L;

    public CountingReadFilter(ReadFilter readFilter) {
        Utils.nonNull(readFilter);
        this.delegateFilter = readFilter;
    }

    public static CountingReadFilter fromList(List<ReadFilter> readFilters, SAMFileHeader samHeader) {
        Utils.nonNull(samHeader, "SAMFileHeader must not be null");
        if (readFilters == null || readFilters.isEmpty()) {
            return new CountingReadFilter(ReadFilterLibrary.ALLOW_ALL_READS);
        }
        readFilters.forEach(f -> f.setHeader(samHeader));
        CountingReadFilter compositeFilter = new CountingReadFilter(readFilters.get(0));
        for (int i = 1; i < readFilters.size(); ++i) {
            compositeFilter = compositeFilter.and(new CountingReadFilter(readFilters.get(i)));
        }
        return compositeFilter;
    }

    private CountingReadFilter() {
        this.delegateFilter = null;
    }

    public long getFilteredCount() {
        return this.filteredCount;
    }

    public void resetFilteredCount() {
        this.filteredCount = 0L;
    }

    public String getName() {
        return this.delegateFilter.getClass().getSimpleName();
    }

    public String getSummaryLine() {
        return this.getSummaryLineForLevel(0);
    }

    protected String getSummaryLineForLevel(int indentLevel) {
        return this.getIndentString(indentLevel) + Long.toString(this.filteredCount) + " read(s) filtered by: " + this.getName() + " \n";
    }

    protected String getIndentString(int indentLevel) {
        StringBuilder bldr = new StringBuilder();
        IntStream.range(0, indentLevel).forEach(i -> bldr.append("  "));
        return bldr.toString();
    }

    public CountingReadFilter and(CountingReadFilter other) {
        Utils.nonNull(other);
        return new CountingAndReadFilter(this, other);
    }

    public CountingReadFilter or(CountingReadFilter other) {
        Utils.nonNull(other);
        return new CountingOrReadFilter(this, other);
    }

    @Override
    public CountingReadFilter negate() {
        return new CountingNegateReadFilter(this);
    }

    @Override
    public boolean test(GATKRead read) {
        boolean accept = this.delegateFilter.test(read);
        if (!accept) {
            ++this.filteredCount;
        }
        return accept;
    }

    private static final class CountingOrReadFilter
    extends CountingBinopReadFilter {
        private static final long serialVersionUID = 1L;

        private CountingOrReadFilter(CountingReadFilter lhs, CountingReadFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(GATKRead read) {
            boolean accept;
            boolean bl = accept = this.lhs.test(read) || this.rhs.test(read);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        public String getName() {
            return "(" + this.lhs.getName() + " OR " + this.rhs.getName() + ")";
        }
    }

    @VisibleForTesting
    protected static final class CountingAndReadFilter
    extends CountingBinopReadFilter {
        private static final long serialVersionUID = 1L;

        private CountingAndReadFilter(CountingReadFilter lhs, CountingReadFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(GATKRead read) {
            boolean accept;
            boolean bl = accept = this.lhs.test(read) && this.rhs.test(read);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        protected String getSummaryLineForLevel(int indentLevel) {
            String simplifiedSummary;
            if (indentLevel == 0 && !(simplifiedSummary = this.getSummaryLineForLevelAllAndsSimplified()).isEmpty()) {
                return simplifiedSummary;
            }
            return super.getSummaryLineForLevel(indentLevel);
        }

        private String getSummaryLineForLevelAllAndsSimplified() {
            StringBuilder summaryLine = new StringBuilder();
            Stack<CountingReadFilter> unread = new Stack<CountingReadFilter>();
            unread.push(this.rhs);
            unread.push(this.lhs);
            while (!unread.empty()) {
                CountingReadFilter curFilter = (CountingReadFilter)unread.pop();
                if (curFilter instanceof CountingAndReadFilter) {
                    unread.push(((CountingAndReadFilter)curFilter).rhs);
                    unread.push(((CountingAndReadFilter)curFilter).lhs);
                    continue;
                }
                if (curFilter instanceof CountingBinopReadFilter || curFilter instanceof CountingNegateReadFilter) {
                    return "";
                }
                summaryLine.append(curFilter.getSummaryLineForLevel(0));
            }
            summaryLine.append(this.getFilteredCount() + " total reads filtered");
            return summaryLine.toString();
        }

        @Override
        public String getName() {
            return "(" + this.lhs.getName() + " AND " + this.rhs.getName() + ")";
        }
    }

    private static abstract class CountingBinopReadFilter
    extends CountingReadFilter {
        private static final long serialVersionUID = 1L;
        protected final CountingReadFilter lhs;
        protected final CountingReadFilter rhs;

        public CountingBinopReadFilter(CountingReadFilter lhs, CountingReadFilter rhs) {
            Utils.nonNull(lhs);
            Utils.nonNull(rhs);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        protected String getSummaryLineForLevel(int indentLevel) {
            String indent = this.getIndentString(indentLevel);
            if (0L == this.filteredCount) {
                return indent + "0 read(s) filtered by: " + this.getName() + " \n";
            }
            return indent + Long.toString(this.filteredCount) + " read(s) filtered by: " + this.getName() + "\n" + (this.lhs.getFilteredCount() > 0L ? this.lhs.getSummaryLineForLevel(indentLevel + 1) : "") + (this.rhs.getFilteredCount() > 0L ? this.rhs.getSummaryLineForLevel(indentLevel + 1) : "");
        }

        @Override
        public void resetFilteredCount() {
            super.resetFilteredCount();
            this.lhs.resetFilteredCount();
            this.rhs.resetFilteredCount();
        }

        @Override
        public abstract String getName();
    }

    private static class CountingNegateReadFilter
    extends CountingReadFilter {
        private static final long serialVersionUID = 1L;
        CountingReadFilter delegateCountingFilter;

        public CountingNegateReadFilter(CountingReadFilter delegate) {
            this.delegateCountingFilter = delegate;
        }

        @Override
        public boolean test(GATKRead read) {
            boolean accept;
            boolean bl = accept = !this.delegateCountingFilter.test(read);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        public String getName() {
            return "NOT " + this.delegateCountingFilter.getName();
        }
    }
}

