/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.stream.IntStream;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;
import org.broadinstitute.hellbender.engine.filters.VariantFilterLibrary;
import org.broadinstitute.hellbender.utils.Utils;

public class CountingVariantFilter
implements VariantFilter {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    protected final VariantFilter delegateFilter;
    protected long filteredCount = 0L;

    public CountingVariantFilter(VariantFilter variantFilter) {
        this.delegateFilter = Utils.nonNull(variantFilter);
    }

    public static CountingVariantFilter fromList(List<VariantFilter> variantFilters) {
        if (variantFilters == null || variantFilters.isEmpty()) {
            return new CountingVariantFilter(VariantFilterLibrary.ALLOW_ALL_VARIANTS);
        }
        CountingVariantFilter compositeFilter = new CountingVariantFilter(variantFilters.get(0));
        for (int i = 1; i < variantFilters.size(); ++i) {
            compositeFilter = compositeFilter.and(new CountingVariantFilter(variantFilters.get(i)));
        }
        return compositeFilter;
    }

    private CountingVariantFilter() {
        this.delegateFilter = null;
    }

    public long getFilteredCount() {
        return this.filteredCount;
    }

    public void resetFilteredCount() {
        this.filteredCount = 0L;
    }

    public String getName() {
        return this.delegateFilter.getClass().getSimpleName();
    }

    public String getSummaryLine() {
        return this.getSummaryLineForLevel(0);
    }

    protected String getSummaryLineForLevel(int indentLevel) {
        if (0L == this.filteredCount) {
            return "No variants filtered by: " + this.getName();
        }
        return this.getIndentString(indentLevel) + Long.toString(this.filteredCount) + " variant(s) filtered by: " + this.getName() + " \n";
    }

    protected String getIndentString(int indentLevel) {
        StringBuilder bldr = new StringBuilder();
        IntStream.range(0, indentLevel).forEach(i -> bldr.append("  "));
        return bldr.toString();
    }

    public CountingVariantFilter and(CountingVariantFilter other) {
        Utils.nonNull(other);
        return new CountingAndVariantFilter(this, other);
    }

    public CountingVariantFilter or(CountingVariantFilter other) {
        Utils.nonNull(other);
        return new CountingOrVariantFilter(this, other);
    }

    @Override
    public CountingVariantFilter negate() {
        return new CountingNegateVariantFilter(this);
    }

    @Override
    public boolean test(VariantContext variant) {
        boolean accept = this.delegateFilter.test(variant);
        if (!accept) {
            ++this.filteredCount;
        }
        return accept;
    }

    private static final class CountingOrVariantFilter
    extends CountingBinopVariantFilter {
        private static final long serialVersionUID = 1L;

        private CountingOrVariantFilter(CountingVariantFilter lhs, CountingVariantFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(VariantContext variant) {
            boolean accept;
            boolean bl = accept = this.lhs.test(variant) || this.rhs.test(variant);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        public String getName() {
            return "(" + this.lhs.getName() + " OR " + this.rhs.getName() + ")";
        }
    }

    @VisibleForTesting
    protected static final class CountingAndVariantFilter
    extends CountingBinopVariantFilter {
        private static final long serialVersionUID = 1L;

        private CountingAndVariantFilter(CountingVariantFilter lhs, CountingVariantFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(VariantContext variant) {
            boolean accept;
            boolean bl = accept = this.lhs.test(variant) && this.rhs.test(variant);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        public String getName() {
            return "(" + this.lhs.getName() + " AND " + this.rhs.getName() + ")";
        }
    }

    private static abstract class CountingBinopVariantFilter
    extends CountingVariantFilter {
        private static final long serialVersionUID = 1L;
        protected final CountingVariantFilter lhs;
        protected final CountingVariantFilter rhs;

        public CountingBinopVariantFilter(CountingVariantFilter lhs, CountingVariantFilter rhs) {
            Utils.nonNull(lhs);
            Utils.nonNull(rhs);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        protected String getSummaryLineForLevel(int indentLevel) {
            String indent = this.getIndentString(indentLevel);
            if (0L == this.filteredCount) {
                return "No variants filtered by: " + this.getName();
            }
            return indent + Long.toString(this.filteredCount) + " variant(s) filtered by: " + this.getName() + "\n" + (this.lhs.getFilteredCount() > 0L ? indent + this.lhs.getSummaryLineForLevel(indentLevel + 1) : "") + (this.rhs.getFilteredCount() > 0L ? indent + this.rhs.getSummaryLineForLevel(indentLevel + 1) : "");
        }

        @Override
        public void resetFilteredCount() {
            super.resetFilteredCount();
            this.lhs.resetFilteredCount();
            this.rhs.resetFilteredCount();
        }

        @Override
        public abstract String getName();
    }

    private static class CountingNegateVariantFilter
    extends CountingVariantFilter {
        private static final long serialVersionUID = 1L;
        CountingVariantFilter delegateCountingFilter;

        public CountingNegateVariantFilter(CountingVariantFilter delegate) {
            this.delegateCountingFilter = delegate;
        }

        @Override
        public boolean test(VariantContext variant) {
            boolean accept;
            boolean bl = accept = !this.delegateCountingFilter.test(variant);
            if (!accept) {
                ++this.filteredCount;
            }
            return accept;
        }

        @Override
        public String getName() {
            return "Not " + this.delegateCountingFilter.getName();
        }
    }
}

