/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only read pairs with insert length less than or equal to the given value")
public final class FragmentLengthReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="max-fragment-length", doc="Maximum length of fragment (insert size)", optional=true)
    public int maxFragmentLength = 1000000;
    @Argument(fullName="min-fragment-length", doc="Minimum length of fragment (insert size)", optional=true)
    public int minFragmentLength = 0;

    @Override
    public boolean test(GATKRead read) {
        if (!read.isPaired()) {
            return true;
        }
        return Math.abs(read.getFragmentLength()) <= this.maxFragmentLength && Math.abs(read.getFragmentLength()) >= this.minFragmentLength;
    }
}

