/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.GenomeLocSortedSet;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalSetRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filters out reads that don't overlap the specified region. NOTE: This approach to extracting overlapping reads is very slow compared to using PrintReads and -L on an indexed bam file.")
public final class IntervalOverlapReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="keep-intervals", suppressFileExpansion=true, doc="One or more genomic intervals to keep", optional=false)
    protected final List<String> intervalStrings;
    private OverlapDetector<?> detector;
    protected final OneShotLogger warning = new OneShotLogger(this.getClass());

    public IntervalOverlapReadFilter() {
        this.intervalStrings = new ArrayList<String>();
    }

    public IntervalOverlapReadFilter(List<String> intervalStrings) {
        this.intervalStrings = new ArrayList<String>(intervalStrings);
    }

    @Override
    public boolean test(GATKRead read) {
        return this.getDetector().overlapsAny((Locatable)read);
    }

    private synchronized OverlapDetector<?> getDetector() {
        if (this.detector == null) {
            this.warning.warn("You are using the IntervalOverlapReadFilter to subset your input, this is a very slow operation and it will usually be preferable to use the '-L' command or provide an interval list file for a sorted and indexed input file");
            GenomeLocParser genomeLocParser = new GenomeLocParser(this.samHeader.getSequenceDictionary());
            GenomeLocSortedSet intervals = IntervalUtils.loadIntervals(this.intervalStrings, IntervalSetRule.UNION, IntervalMergingRule.ALL, 0, genomeLocParser);
            this.detector = OverlapDetector.create(intervals.toList());
        }
        return this.detector;
    }
}

