/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads from the specified library")
public final class LibraryReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="library", shortName="library", doc="Name of the library to keep", optional=false)
    public Set<String> libraryToKeep = new LinkedHashSet<String>();

    public LibraryReadFilter() {
    }

    public LibraryReadFilter(SAMFileHeader header) {
        super.setHeader(header);
    }

    @Override
    public boolean test(GATKRead read) {
        String library = ReadUtils.getLibrary(read, this.samHeader);
        if (library == null) {
            return false;
        }
        return this.libraryToKeep.contains(library);
    }
}

