/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads with mapping qualities within a specified range", extraDocs={ReadFilterLibrary.MappingQualityAvailableReadFilter.class})
public final class MappingQualityReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="minimum-mapping-quality", doc="Minimum mapping quality to keep (inclusive)", optional=true)
    public int minMappingQualityScore = 10;
    @Argument(fullName="maximum-mapping-quality", doc="Maximum mapping quality to keep (inclusive)", optional=true)
    public Integer maxMappingQualityScore = null;

    public MappingQualityReadFilter() {
    }

    public MappingQualityReadFilter(int minMappingQualityScore) {
        this.minMappingQualityScore = minMappingQualityScore;
    }

    public MappingQualityReadFilter(int minMappingQualityScore, Integer maxMappingQualityScore) {
        this.minMappingQualityScore = minMappingQualityScore;
        this.maxMappingQualityScore = maxMappingQualityScore;
    }

    @Override
    public boolean test(GATKRead read) {
        int mq = read.getMappingQuality();
        return mq >= this.minMappingQualityScore && (this.maxMappingQualityScore == null || mq <= this.maxMappingQualityScore);
    }
}

