/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only paired reads with mates mapped >= mate-too-distant-length (default 1KB) apart or on different contigs", extraDocs={ReadFilterLibrary.MappedReadFilter.class})
public class MateDistantReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="mate-too-distant-length", doc="Minimum start location difference at which mapped mates are considered distant", optional=true)
    public static final int mateTooDistantLength = 1000;

    @Override
    public boolean test(GATKRead read) {
        return read.isPaired() && !read.isUnmapped() && !read.mateIsUnmapped() && (Math.abs(read.getStart() - read.getMateStart()) >= 1000 || !read.getContig().equals(read.getMateContig()));
    }
}

