/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads that fail platform quality checks, are unmapped and represent secondary/supplementary alignments")
public final class MetricsReadFilter
extends ReadFilter {
    static final long serialVersionUID = 1L;
    private final boolean pfReadOnly;
    private final boolean alignedReadsOnly;

    public MetricsReadFilter() {
        this(true, true);
    }

    public MetricsReadFilter(boolean pfReadOnly, boolean alignedReadsOnly) {
        this.pfReadOnly = pfReadOnly;
        this.alignedReadsOnly = alignedReadsOnly;
    }

    @Override
    public boolean test(GATKRead read) {
        return !(this.pfReadOnly && read.failsVendorQualityCheck() || this.alignedReadsOnly && read.isUnmapped() || read.isSecondaryAlignment() || read.isSupplementaryAlignment());
    }

    public String toString() {
        return "[MetricsReadFilter{pfReadOnly: " + this.pfReadOnly + ", alignedReadsOnly: " + this.alignedReadsOnly + "}]";
    }
}

