/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads that are over-soft-clipped")
public final class OverclippedReadFilter
extends ReadFilter {
    static final long serialVersionUID = 1L;
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Argument(fullName="filter-too-short", doc="Minimum number of aligned bases", optional=true)
    private int minAlignedBases = 30;
    @Argument(fullName="dont-require-soft-clips-both-ends", doc="Allow a read to be filtered out based on having only 1 soft-clipped block. By default, both ends must have a soft-clipped block, setting this flag requires only 1 soft-clipped block", optional=true)
    private boolean doNotRequireSoftClipsOnBothEnds;

    public OverclippedReadFilter() {
    }

    @VisibleForTesting
    OverclippedReadFilter(int minAlignedBases) {
        this.minAlignedBases = minAlignedBases;
    }

    @VisibleForTesting
    OverclippedReadFilter(int minAlignedBases, boolean doNotRequireSoftClipsOnBothEnds) {
        this.minAlignedBases = minAlignedBases;
        this.doNotRequireSoftClipsOnBothEnds = doNotRequireSoftClipsOnBothEnds;
    }

    @Override
    public boolean test(GATKRead read) {
        int alignedLength = 0;
        int softClipBlocks = 0;
        int minSoftClipBlocks = this.doNotRequireSoftClipsOnBothEnds ? 1 : 2;
        CigarOperator prevOperator = null;
        for (CigarElement element : read.getCigarElements()) {
            if (element.getOperator() == CigarOperator.S) {
                if (prevOperator != CigarOperator.S) {
                    ++softClipBlocks;
                }
            } else if (element.getOperator().consumesReadBases()) {
                alignedLength += element.getLength();
            }
            prevOperator = element.getOperator();
        }
        return alignedLength >= this.minAlignedBases || softClipBlocks < minSoftClipBlocks;
    }
}

