/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads with matching Read Group platform")
public final class PlatformReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="platform-filter-name", doc="Platform attribute (PL) to match", optional=false)
    public Set<String> PLFilterNames = new LinkedHashSet<String>();

    public PlatformReadFilter() {
    }

    public PlatformReadFilter(SAMFileHeader header) {
        super.setHeader(header);
    }

    @Override
    public boolean test(GATKRead read) {
        String platform = ReadUtils.getPlatform(read, this.samHeader);
        if (platform == null) {
            return false;
        }
        platform = platform.toUpperCase();
        for (String name : this.PLFilterNames) {
            if (!platform.contains(name.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

