/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTag;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads with matching platform unit attribute")
public final class PlatformUnitReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="black-listed-lanes", doc="Platform unit (PU) to filter out", optional=false)
    public Set<String> blackListedLanes = new LinkedHashSet<String>();

    public PlatformUnitReadFilter() {
    }

    public PlatformUnitReadFilter(SAMFileHeader header) {
        super.setHeader(header);
    }

    @Override
    public boolean test(GATKRead read) {
        if (this.blackListedLanes.isEmpty()) {
            return true;
        }
        String pu_attr = this.getPlatformUnit(read);
        return pu_attr == null || !this.blackListedLanes.contains(pu_attr);
    }

    private String getPlatformUnit(GATKRead read) {
        String pu_attr = read.getAttributeAsString(SAMTag.PU.name());
        if (pu_attr != null) {
            return pu_attr;
        }
        return ReadUtils.getPlatformUnit(read, this.samHeader);
    }
}

