/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class ReadFilter
implements Predicate<GATKRead>,
Serializable {
    protected SAMFileHeader samHeader = null;
    private static final long serialVersionUID = 1L;

    public void setHeader(SAMFileHeader samHeader) {
        this.samHeader = samHeader;
    }

    public static ReadFilter fromList(List<ReadFilter> readFilters, SAMFileHeader samHeader) {
        Utils.nonNull(samHeader, "SAMFileHeader must not be null");
        if (readFilters == null || readFilters.isEmpty()) {
            return ReadFilterLibrary.ALLOW_ALL_READS;
        }
        readFilters.forEach(f -> f.setHeader(samHeader));
        ReadFilter compositeFilter = readFilters.get(0);
        for (int i = 1; i < readFilters.size(); ++i) {
            compositeFilter = compositeFilter.and(readFilters.get(i));
        }
        return compositeFilter;
    }

    public ReadFilter and(ReadFilter other) {
        Utils.nonNull(other);
        return new ReadFilterAnd(this, other);
    }

    public ReadFilter or(ReadFilter other) {
        Utils.nonNull(other);
        return new ReadFilterOr(this, other);
    }

    public ReadFilter negate() {
        return new ReadFilterNegate(this);
    }

    @Override
    public abstract boolean test(GATKRead var1);

    private static class ReadFilterOr
    extends ReadFilterBinOp {
        private static final long serialVersionUID = 1L;

        public ReadFilterOr(ReadFilter lhs, ReadFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(GATKRead read) {
            return this.lhs.test(read) || this.rhs.test(read);
        }
    }

    @VisibleForTesting
    protected static class ReadFilterAnd
    extends ReadFilterBinOp {
        private static final long serialVersionUID = 1L;

        public ReadFilterAnd(ReadFilter lhs, ReadFilter rhs) {
            super(lhs, rhs);
        }

        @Override
        public boolean test(GATKRead read) {
            return this.lhs.test(read) && this.rhs.test(read);
        }
    }

    protected static abstract class ReadFilterBinOp
    extends ReadFilter {
        private static final long serialVersionUID = 1L;
        protected final ReadFilter lhs;
        protected final ReadFilter rhs;

        public ReadFilterBinOp(ReadFilter lhs, ReadFilter rhs) {
            Utils.nonNull(lhs, "ReadFilterBinOp lhs filter cannot be null");
            Utils.nonNull(rhs, "ReadFilterBinOp rhs filter cannot be null");
            this.lhs = lhs;
            this.rhs = rhs;
        }
    }

    private static class ReadFilterNegate
    extends ReadFilter {
        private static final long serialVersionUID = 1L;
        private final ReadFilter delegate;

        protected ReadFilterNegate(ReadFilter delegate) {
            Utils.nonNull(delegate, "Delegate filter cannot be null");
            this.delegate = delegate;
        }

        @Override
        public boolean test(GATKRead read) {
            return !this.delegate.test(read);
        }
    }
}

