/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.Cigar;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.MateDistantReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.tools.AddOriginalAlignmentTags;
import org.broadinstitute.hellbender.utils.read.CigarUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class ReadFilterLibrary {
    public static final AllowAllReadsReadFilter ALLOW_ALL_READS = new AllowAllReadsReadFilter();
    public static final CigarContainsNoNOperator CIGAR_CONTAINS_NO_N_OPERATOR = new CigarContainsNoNOperator();
    public static final FirstOfPairReadFilter FIRST_OF_PAIR = new FirstOfPairReadFilter();
    public static final GoodCigarReadFilter GOOD_CIGAR = new GoodCigarReadFilter();
    public static final HasReadGroupReadFilter HAS_READ_GROUP = new HasReadGroupReadFilter();
    public static final MappedReadFilter MAPPED = new MappedReadFilter();
    public static final MappingQualityAvailableReadFilter MAPPING_QUALITY_AVAILABLE = new MappingQualityAvailableReadFilter();
    public static final MappingQualityNotZeroReadFilter MAPPING_QUALITY_NOT_ZERO = new MappingQualityNotZeroReadFilter();
    public static final MatchingBasesAndQualsReadFilter HAS_MATCHING_BASES_AND_QUALS = new MatchingBasesAndQualsReadFilter();
    public static final MateOnSameContigOrNoMappedMateReadFilter MATE_ON_SAME_CONTIG_OR_NO_MAPPED_MATE = new MateOnSameContigOrNoMappedMateReadFilter();
    public static final MateDifferentStrandReadFilter MATE_DIFFERENT_STRAND = new MateDifferentStrandReadFilter();
    public static final MateDistantReadFilter MATE_DISTANT = new MateDistantReadFilter();
    public static final NonZeroReferenceLengthAlignmentReadFilter NON_ZERO_REFERENCE_LENGTH_ALIGNMENT = new NonZeroReferenceLengthAlignmentReadFilter();
    public static final NonZeroFragmentLengthReadFilter NONZERO_FRAGMENT_LENGTH_READ_FILTER = new NonZeroFragmentLengthReadFilter();
    public static final NotDuplicateReadFilter NOT_DUPLICATE = new NotDuplicateReadFilter();
    public static final NotProperlyPairedReadFilter NOT_PROPERLY_PAIRED = new NotProperlyPairedReadFilter();
    public static final NotSecondaryAlignmentReadFilter NOT_SECONDARY_ALIGNMENT = new NotSecondaryAlignmentReadFilter();
    public static final NotSupplementaryAlignmentReadFilter NOT_SUPPLEMENTARY_ALIGNMENT = new NotSupplementaryAlignmentReadFilter();
    public static final PairedReadFilter PAIRED = new PairedReadFilter();
    public static final ProperlyPairedReadFilter PROPERLY_PAIRED = new ProperlyPairedReadFilter();
    public static final PassesVendorQualityCheckReadFilter PASSES_VENDOR_QUALITY_CHECK = new PassesVendorQualityCheckReadFilter();
    public static final PrimaryLineReadFilter PRIMARY_LINE = new PrimaryLineReadFilter();
    public static final ReadLengthEqualsCigarLengthReadFilter READLENGTH_EQUALS_CIGARLENGTH = new ReadLengthEqualsCigarLengthReadFilter();
    public static final SecondOfPairReadFilter SECOND_OF_PAIR = new SecondOfPairReadFilter();
    public static final SeqIsStoredReadFilter SEQ_IS_STORED = new SeqIsStoredReadFilter();
    public static final ValidAlignmentStartReadFilter VALID_ALIGNMENT_START = new ValidAlignmentStartReadFilter();
    public static final ValidAlignmentEndReadFilter VALID_ALIGNMENT_END = new ValidAlignmentEndReadFilter();
    public static final NonChimericOriginalAlignmentReadFilter NON_CHIMERIC_ORIGINAL_ALIGNMENT_READ_FILTER = new NonChimericOriginalAlignmentReadFilter();
    public static final MateUnmappedAndUnmappedReadFilter MATE_UNMAPPED_AND_UNMAPPED_READ_FILTER = new MateUnmappedAndUnmappedReadFilter();

    private ReadFilterLibrary() {
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filters reads whose mate is unmapped as well as unmapped reads.")
    public static class MateUnmappedAndUnmappedReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isUnmapped() && (!read.isPaired() || !read.mateIsUnmapped());
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filters reads whose original alignment was chimeric.")
    public static class NonChimericOriginalAlignmentReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            if (read.hasAttribute("OA") && read.hasAttribute("XM")) {
                return AddOriginalAlignmentTags.getOAContig(read).equals(read.getAttributeAsString("XM"));
            }
            return true;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads where the read end is properly aligned", extraDocs={MappedReadFilter.class})
    public static class ValidAlignmentEndReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isUnmapped() || read.getEnd() - read.getStart() + 1 >= 0;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads with a valid alignment start", extraDocs={MappedReadFilter.class})
    public static class ValidAlignmentStartReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isUnmapped() || read.getStart() > 0;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads with sequenced bases")
    public static class SeqIsStoredReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getLength() > 0;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only paired reads that are second of pair")
    public static class SecondOfPairReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isSecondOfPair();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads  where the read and CIGAR do not match in length", extraDocs={MappedReadFilter.class})
    public static class ReadLengthEqualsCigarLengthReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isUnmapped() || read.getLength() == Cigar.getReadLength(read.getCigarElements());
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis")
    public static class PrimaryLineReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isSecondaryAlignment() && !read.isSupplementaryAlignment();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads that are properly paired")
    public static class ProperlyPairedReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isProperlyPaired();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads failing platfor/vendor quality checks")
    public static class PassesVendorQualityCheckReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.failsVendorQualityCheck();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out unpaired reads")
    public static class PairedReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isPaired();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads representing supplementary alignments")
    public static class NotSupplementaryAlignmentReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isSupplementaryAlignment();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads representing secondary alignments")
    public static class NotSecondaryAlignmentReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isSecondaryAlignment();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only paired reads that are not properly paired")
    public static class NotProperlyPairedReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isPaired() && !read.isProperlyPaired();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads marked as duplicate")
    public static class NotDuplicateReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isDuplicate();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads that do not align to the reference")
    public static class NonZeroReferenceLengthAlignmentReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getCigarElements().stream().anyMatch(c -> c.getOperator().consumesReferenceBases() && c.getLength() > 0);
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads with mates mapped on the different strand", extraDocs={MappedReadFilter.class})
    public static class MateDifferentStrandReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isPaired() && !read.isUnmapped() && !read.mateIsUnmapped() && read.mateIsReverseStrand() != read.isReverseStrand();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads whose mate maps to the same contig or is unmapped", extraDocs={MappedReadFilter.class})
    public static class MateOnSameContigOrNoMappedMateReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isPaired() || read.mateIsUnmapped() || !read.isUnmapped() && read.getContig().equals(read.getMateContig());
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads with mapping quality equal to zero")
    public static class MappingQualityNotZeroReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getMappingQuality() != 0;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads without available mapping quality")
    public static class MappingQualityAvailableReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getMappingQuality() != 255;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out unmapped reads")
    public static class MappedReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !read.isUnmapped();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads without Read Group")
    public static class HasReadGroupReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getReadGroup() != null;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads where the bases and qualities do not match")
    public static class MatchingBasesAndQualsReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getLength() == read.getBaseQualityCount();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads with fragment length different from zero")
    public static class NonZeroFragmentLengthReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.getFragmentLength() != 0;
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads containing good CIGAR string")
    public static class GoodCigarReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return CigarUtils.isGood(read.getCigar());
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads that are first of pair")
    public static class FirstOfPairReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return read.isFirstOfPair();
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads with CIGAR containing N operator")
    public static class CigarContainsNoNOperator
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return !CigarUtils.containsNOperator(read.getCigarElements());
        }
    }

    @DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Do not filter out any read")
    public static class AllowAllReadsReadFilter
    extends ReadFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(GATKRead read) {
            return true;
        }
    }
}

