/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMTag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis")
public final class ReadGroupBlackListReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILTER_ENTRY_SEPARATOR = ":";
    @Argument(fullName="read-group-black-list", doc="A read group filter expression in the form \"attribute:value\", where \"attribute\" is a two character read group attribute such as \"RG\" or \"PU\".", optional=false)
    public List<String> blackList = new ArrayList<String>();
    private final Map<String, Collection<String>> blacklistEntries = new HashMap<String, Collection<String>>();

    public ReadGroupBlackListReadFilter() {
    }

    @Override
    public void setHeader(SAMFileHeader samFileHeader) {
        super.setHeader(samFileHeader);
        this.parseReadGroupFilters();
    }

    public ReadGroupBlackListReadFilter(List<String> blackLists, SAMFileHeader header) {
        super.setHeader(header);
        this.blackList.addAll(blackLists);
        this.parseReadGroupFilters();
    }

    private void parseReadGroupFilters() {
        TreeMap<String, Collection<String>> filters = new TreeMap<String, Collection<String>>();
        for (String blackList : this.blackList) {
            this.addFilters(filters, blackList);
        }
        filters.forEach((k, v) -> this.blacklistEntries.merge((String)k, (Collection<String>)v, (v1, v2) -> {
            v1.addAll(v2);
            return v1;
        }));
    }

    private void addFilters(Map<String, Collection<String>> filters, String filter) {
        String[] split = filter.split(FILTER_ENTRY_SEPARATOR, 2);
        this.checkValidFilterEntry(filter, split);
        filters.computeIfAbsent(split[0], k -> new TreeSet()).add(split[1]);
    }

    private void checkValidFilterEntry(String filter, String[] split) {
        String message = null;
        if (split.length != 2) {
            message = "Invalid read group filter: " + filter;
        } else if (split[0].length() != 2) {
            message = "Tag is not two characters: " + filter;
        }
        if (message != null) {
            message = message + ", format is <TAG>:<SUBSTRING>";
            throw new UserException(message);
        }
    }

    @Override
    public boolean test(GATKRead read) {
        SAMReadGroupRecord readGroup = ReadUtils.getSAMReadGroupRecord(read, this.samHeader);
        if (readGroup == null) {
            return true;
        }
        for (String attributeType : this.blacklistEntries.keySet()) {
            String attribute = "ID".equals(attributeType) || SAMTag.RG.name().equals(attributeType) ? readGroup.getId() : readGroup.getAttribute(attributeType);
            if (attribute == null || !this.blacklistEntries.get(attributeType).contains(attribute)) continue;
            return false;
        }
        return true;
    }
}

