/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads whose length is within a certain range")
public final class ReadLengthReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="max-read-length", doc="Keep only reads with length at most equal to the specified value", optional=false)
    public Integer maxReadLength;
    @Argument(fullName="min-read-length", doc="Keep only reads with length at least equal to the specified value", optional=true)
    public int minReadLength = 1;

    public ReadLengthReadFilter() {
    }

    public ReadLengthReadFilter(int minLength, int maxLength) {
        this.minReadLength = minLength;
        this.maxReadLength = maxLength;
    }

    @Override
    public boolean test(GATKRead read) {
        return read.getLength() >= this.minReadLength && read.getLength() <= this.maxReadLength;
    }
}

