/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads whose strand is as specified")
public final class ReadStrandFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="keep-reverse-strand-only", doc="Keep only reads on the reverse strand", optional=false)
    public Boolean keepOnlyReverse;

    public ReadStrandFilter() {
    }

    public ReadStrandFilter(boolean keepOnlyReverse) {
        this.keepOnlyReverse = keepOnlyReverse;
    }

    @Override
    public boolean test(GATKRead read) {
        return read.isReverseStrand() == this.keepOnlyReverse.booleanValue();
    }
}

