/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads for a given sample")
public final class SampleReadFilter
extends ReadFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Argument(fullName="sample", shortName="sample", doc="The name of the sample(s) to keep, filtering out all others", optional=false)
    public Set<String> samplesToKeep = new HashSet<String>();

    public SampleReadFilter() {
    }

    public SampleReadFilter(SAMFileHeader header) {
        super.setHeader(header);
    }

    @Override
    public boolean test(GATKRead read) {
        String sample = ReadUtils.getSampleName(read, this.samHeader);
        return sample != null && this.samplesToKeep.contains(sample);
    }
}

