/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Filter out reads that are over-soft-clipped")
public final class SoftClippedReadFilter
extends ReadFilter {
    static final long serialVersionUID = 1L;
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Argument(fullName="invert-soft-clip-ratio-filter", doc="Inverts the results from this filter, causing all variants that would pass to fail and visa-versa.", optional=true)
    @VisibleForTesting
    boolean doInvertFilter = false;
    @Argument(fullName="soft-clipped-ratio-threshold", doc="Threshold ratio of soft clipped bases (anywhere in the cigar string) to total bases in read for read to be filtered.", optional=true, mutex={"soft-clipped-leading-trailing-ratio"})
    @VisibleForTesting
    Double minimumSoftClippedRatio = null;
    @Argument(fullName="soft-clipped-leading-trailing-ratio", doc="Threshold ratio of soft clipped bases (leading / trailing the cigar string) to total bases in read for read to be filtered.", optional=true, mutex={"soft-clipped-ratio-threshold"})
    @VisibleForTesting
    Double minimumLeadingTrailingSoftClippedRatio = null;

    private boolean testMinSoftClippedRatio(GATKRead read) {
        int totalLength = 0;
        int numSoftClippedBases = 0;
        for (CigarElement element : read.getCigarElements()) {
            if (element.getOperator() == CigarOperator.S) {
                numSoftClippedBases += element.getLength();
            }
            totalLength += element.getLength();
        }
        double softClipRatio = (double)numSoftClippedBases / (double)totalLength;
        return softClipRatio > this.minimumSoftClippedRatio;
    }

    private boolean testMinLeadingTrailingSoftClippedRatio(GATKRead read) {
        if (read.getCigarElements().size() < 1) {
            return false;
        }
        int lastCigarOpIndex = read.getCigarElements().size() - 1;
        int numLeadingTrailingSoftClippedBases = (read.getCigarElement(0).getOperator() == CigarOperator.S ? read.getCigarElement(0).getLength() : 0) + (lastCigarOpIndex != 0 && read.getCigarElement(lastCigarOpIndex).getOperator() == CigarOperator.S ? read.getCigarElement(lastCigarOpIndex).getLength() : 0);
        int totalLength = read.getCigarElements().stream().mapToInt(CigarElement::getLength).sum();
        double softClipRatio = (double)numLeadingTrailingSoftClippedBases / (double)totalLength;
        return softClipRatio > this.minimumLeadingTrailingSoftClippedRatio;
    }

    @Override
    public boolean test(GATKRead read) {
        boolean result;
        if (this.minimumSoftClippedRatio != null) {
            result = this.testMinSoftClippedRatio(read);
        } else if (this.minimumLeadingTrailingSoftClippedRatio != null) {
            result = this.testMinLeadingTrailingSoftClippedRatio(read);
        } else {
            throw new UserException("Must provide one of the following arguments: soft-clipped-ratio-threshold,soft-clipped-leading-trailing-ratio");
        }
        if (this.doInvertFilter) {
            return !result;
        }
        return result;
    }
}

