/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;

public final class VariantFilterLibrary {
    public static VariantFilter ALLOW_ALL_VARIANTS = new AllowAllVariantsVariantFilter();
    public static VariantFilter NOT_SV_OR_SYMBOLIC = new NotSymbolicOrSVVariantFilter();
    public static VariantFilter PASSES_FILTERS = new PassesFiltersVariantFilter();

    public static class PassesFiltersVariantFilter
    implements VariantFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(VariantContext variant) {
            return !variant.isFiltered();
        }
    }

    public static class NotSymbolicOrSVVariantFilter
    implements VariantFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(VariantContext variant) {
            return !variant.isSymbolicOrSV();
        }
    }

    public static class AllowAllVariantsVariantFilter
    implements VariantFilter {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean test(VariantContext variant) {
            return true;
        }
    }
}

