/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.hellbender.engine.filters.VariantFilter;
import org.broadinstitute.hellbender.utils.Utils;

public final class VariantIDsVariantFilter
implements VariantFilter {
    private static final long serialVersionUID = 1L;
    private final Set<String> includeIDs = new LinkedHashSet<String>();

    public VariantIDsVariantFilter(Set<String> keepIDs) {
        Utils.nonNull(keepIDs);
        this.includeIDs.addAll(keepIDs);
    }

    @Override
    public boolean test(VariantContext vc) {
        return Arrays.stream(vc.getID().split(";")).anyMatch(this.includeIDs::contains);
    }
}

