/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.filters;

import htsjdk.samtools.SAMFileHeader;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.filters.AlignmentAgreesWithHeaderReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Read Filters", groupSummary="Applied by engine to select reads for analysis", summary="Keep only reads that are well-formed", extraDocs={ReadFilterLibrary.ValidAlignmentStartReadFilter.class, ReadFilterLibrary.ValidAlignmentEndReadFilter.class, AlignmentAgreesWithHeaderReadFilter.class, ReadFilterLibrary.HasReadGroupReadFilter.class, ReadFilterLibrary.MatchingBasesAndQualsReadFilter.class, ReadFilterLibrary.ReadLengthEqualsCigarLengthReadFilter.class, ReadFilterLibrary.SeqIsStoredReadFilter.class, ReadFilterLibrary.CigarContainsNoNOperator.class})
public final class WellformedReadFilter
extends ReadFilter {
    private static final long serialVersionUID = 1L;
    private ReadFilter wellFormedFilter = null;

    public WellformedReadFilter() {
    }

    @Override
    public void setHeader(SAMFileHeader header) {
        super.setHeader(header);
        this.createFilter();
    }

    public WellformedReadFilter(SAMFileHeader header) {
        this.setHeader(header);
    }

    private void createFilter() {
        AlignmentAgreesWithHeaderReadFilter alignmentAgreesWithHeader = new AlignmentAgreesWithHeaderReadFilter(this.samHeader);
        this.wellFormedFilter = ReadFilterLibrary.VALID_ALIGNMENT_START.and(ReadFilterLibrary.VALID_ALIGNMENT_END).and(alignmentAgreesWithHeader).and(ReadFilterLibrary.HAS_READ_GROUP).and(ReadFilterLibrary.HAS_MATCHING_BASES_AND_QUALS).and(ReadFilterLibrary.READLENGTH_EQUALS_CIGARLENGTH).and(ReadFilterLibrary.SEQ_IS_STORED).and(ReadFilterLibrary.CIGAR_CONTAINS_NO_N_OPERATOR);
    }

    @Override
    public boolean test(GATKRead read) {
        return this.wellFormedFilter.test(read);
    }
}

