/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.engine.spark;

import java.io.Serializable;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.Hidden;

public class AssemblyRegionArgumentCollection
implements Serializable {
    public static final String ASSEMBLY_REGION_OUT_LONG_NAME = "assembly-region-out";
    public static final String FORCE_ACTIVE_REGIONS_LONG_NAME = "force-active";
    private static final long serialVersionUID = 1L;
    public static final String MIN_ASSEMBLY_LONG_NAME = "min-assembly-region-size";
    public static final String MAX_ASSEMBLY_LONG_NAME = "max-assembly-region-size";
    public static final String ASSEMBLY_PADDING_LONG_NAME = "assembly-region-padding";
    public static final String MAX_STARTS_LONG_NAME = "max-reads-per-alignment-start";
    public static final String THRESHOLD_LONG_NAME = "active-probability-threshold";
    public static final String PROPAGATION_LONG_NAME = "max-prob-propagation-distance";
    public static final int DEFAULT_MIN_ASSEMBLY_REGION_SIZE = 50;
    public static final int DEFAULT_MAX_ASSEMBLY_REGION_SIZE = 300;
    public static final int DEFAULT_ASSEMBLY_REGION_PADDING = 100;
    public static final int DEFAULT_MAX_READS_PER_ALIGNMENT = 50;
    public static final double DEFAULT_ACTIVE_PROB_THRESHOLD = 0.002;
    public static final int DEFAULT_MAX_PROB_PROPAGATION_DISTANCE = 50;
    public static final String INDEL_PADDING_LONG_NAME = "padding-around-indels";
    public static final String SNP_PADDING_LONG_NAME = "padding-around-snps";
    public static final String STR_PADDING_LONG_NAME = "padding-around-strs";
    @Argument(fullName="min-assembly-region-size", doc="Minimum size of an assembly region", optional=true)
    public int minAssemblyRegionSize = this.defaultMinAssemblyRegionSize();
    @Argument(fullName="max-assembly-region-size", doc="Maximum size of an assembly region", optional=true)
    public int maxAssemblyRegionSize = this.defaultMaxAssemblyRegionSize();
    @Advanced
    @Argument(fullName="active-probability-threshold", doc="Minimum probability for a locus to be considered active.", optional=true)
    public double activeProbThreshold = this.defaultActiveProbThreshold();
    @Advanced
    @Argument(fullName="max-prob-propagation-distance", doc="Upper limit on how many bases away probability mass can be moved around when calculating the boundaries between active and inactive assembly regions", optional=true)
    public int maxProbPropagationDistance = this.defaultMaxProbPropagationDistance();
    @Advanced
    @Argument(fullName="force-active", doc="If provided, all regions will be marked as active", optional=true)
    public boolean forceActive = false;
    @Argument(fullName="assembly-region-padding", doc="Number of additional bases of context to include around each assembly region", optional=true)
    public int assemblyRegionPadding = this.defaultAssemblyRegionPadding();
    @Hidden
    @Argument(fullName="padding-around-indels", doc="Include at least this many bases around an event for calling indels", optional=true)
    public int indelPaddingForGenotyping = 75;
    @Hidden
    @Argument(fullName="padding-around-snps", doc="Include at least this many bases around an event for calling snps", optional=true)
    public int snpPaddingForGenotyping = 20;
    @Hidden
    @Argument(fullName="padding-around-strs", doc="Include at least this many bases around an event for calling STR indels", optional=true)
    public int strPaddingForGenotyping = 75;
    @Hidden
    @Argument(fullName="max-extension-into-assembly-region-padding-legacy", doc="the maximum extent into the full active region extension that we're willing to go in genotyping (-1 to disable). NOTE this only applies for --enable-legacy-assembly-region-trimming mode", optional=true)
    public int maxExtensionIntoRegionPadding = 25;
    @Argument(fullName="max-reads-per-alignment-start", doc="Maximum number of reads to retain per alignment start position. Reads above this threshold will be downsampled. Set to 0 to disable.", optional=true)
    public int maxReadsPerAlignmentStart = this.defaultMaxReadsPerAlignmentStart();
    @Hidden
    @Argument(fullName="enable-legacy-assembly-region-trimming", doc="Revert changes to the assembly region windows, this will result in less consistent results for assembly window boundaries", optional=true)
    public boolean enableLegacyAssemblyRegionTrimming = false;

    protected int defaultMinAssemblyRegionSize() {
        return 50;
    }

    protected int defaultMaxAssemblyRegionSize() {
        return 300;
    }

    protected int defaultAssemblyRegionPadding() {
        return 100;
    }

    protected int defaultMaxReadsPerAlignmentStart() {
        return 50;
    }

    protected double defaultActiveProbThreshold() {
        return 0.002;
    }

    protected int defaultMaxProbPropagationDistance() {
        return 50;
    }

    public void validate() {
        if (this.minAssemblyRegionSize <= 0 || this.maxAssemblyRegionSize <= 0) {
            throw new CommandLineException.BadArgumentValue("min/max assembly region size must be > 0");
        }
        if (this.minAssemblyRegionSize > this.maxAssemblyRegionSize) {
            throw new CommandLineException.BadArgumentValue("minAssemblyRegionSize must be <= maxAssemblyRegionSize");
        }
        if (this.assemblyRegionPadding < 0) {
            throw new CommandLineException.BadArgumentValue("assemblyRegionPadding must be >= 0");
        }
        if (this.maxReadsPerAlignmentStart < 0) {
            throw new CommandLineException.BadArgumentValue("maxReadsPerAlignmentStart must be >= 0");
        }
        if (this.snpPaddingForGenotyping < 0) {
            throw new CommandLineException.BadArgumentValue("paddingAroundSNPs", "" + this.snpPaddingForGenotyping + "< 0");
        }
        if (this.indelPaddingForGenotyping < 0) {
            throw new CommandLineException.BadArgumentValue("paddingAroundIndels", "" + this.indelPaddingForGenotyping + "< 0");
        }
    }
}

